************************************************************************
*
* PCG: Preconditioned Conjugate Gradient Package
* Version: f77
*
************************************************************************
************************************************************************
*# 
*#                      COPYRIGHT/DISCLAIMER NOTICE
*#
*# This program was prepared by the Regents of the University of
*# California at Los Alamos National Laboratory under Contract No.
*# W-7405-ENG-36 with the U.S. Department of Energy (DOE), and by
*# the University of Texas at Austin under ARPA Contract No.
*# DABT63-92-C-0024.
*# 
*# The University of California and the University of Texas at
*# Austin have certain rights in the program pursuant to these
*# contracts.
*# 
*# Permission is hereby granted to use the program for the user's
*# own internal use.  The user is not granted the right to reproduce,
*# prepare derivative works, or redistribute the program without
*# prior permission of the University of California or the University
*# of Texas at Austin.
*# 
*# All rights in the program are reserved by the University of
*# California and the University of Texas at Austin.
*# 
*# Portions of this material resulted from work developed under a
*# U.S. Government Contract and are subject to the following
*# license: the Government is granted for itself and others acting
*# on its behalf a paid-up, nonexclusive, irrevocable worldwide
*# license in this computer software to reproduce, prepare derivative
*# works, and perform publicly and display publicly.
*# 
*# Neither the U.S. Government, the University of California nor
*# the University of Texas at Austin, nor any of their employees,
*# makes any warranty, express or implied, or assumes any liability
*# or responsibility for the use of this software.
*# 
*# Copyright (c) 1992-1995 the University of California and the
*# University of Texas at Austin.
*# 
************************************************************************
************************************************************************
************************************************************************
**  ^ROUTINE: WARGCK - Routine to check the validity of iparm and
**                     fparm entries on entry to the package. (^)
**
************************************************************************
**
      subroutine cargck	( iparm , fparm , iwk , fwk , ier )
**
************************************************************************
**
**  ^DESCRIPTION:
**    Routine to check the validity of iparm and fparm entries on
**    entry to the package.  Warnings or errors are given if necessary.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**    This program makes heavy use of the definitions in defs_ifparm.m4
**
**  ^SIDE_EFFECTS:
**    The i/fparm variables associated with the timers are initialized.
**    The ier error code is set if necessary.
**
**  ^DOCUMENTATION:
**
**  ^MACROS:
**
************************************************************************
*
*     implicit character*1 (a-z)
*
      integer ier
      integer iwk(*)
      integer iparm(*)
      complex       fwk(*)
      complex       fparm(*)
*#    BASICAL    - (^)
*
      integer icallr
      real relpr
*
      real    cmch
      external cmch
      external xerstr
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov Mon Aug 28 19:20:55 MDT 1995
*     $Id: argck.fm4,v 1.15 1994/09/06 17:34:33 joubert Exp $
*     $Revision: 1.0 $
************************************************************************
*
*
      icallr = iparm(27)
*
        if (.not.(iparm(2).ge.0 .and. iparm(2).le.5)) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'levout' )
                go to 900
        endif
        if (.not.(iparm(3)   .ge.0  )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'nru   ' )
                go to 900
        endif
        if (.not.(iparm(4).ge.0  )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'itsmax' )
                go to 900
        endif
        if (.not.(iparm(6).eq.0)) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'malloc' )
                go to 900
        endif
        if (.not.(iparm(7).ge.1     )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'nwi   ' )
                go to 900
        endif
        if (.not.(iparm(8).ge.1     )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'nwf   ' )
                go to 900
        endif
        if (.not.(iparm(12) .ge.-3 .and. iparm(12) .le.8 .and..not.
     &              (iparm(12) .eq.-3 .and. iparm(27) .ne.0).and..not.
     &              (iparm(12) .eq.-2 .and. iparm(19).ne.1))) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'ntest ' )
                go to 900
        endif
        if (.not.(iparm(13).ge.0  .and. iparm(13).le.3 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'iqside' )
                go to 900
        endif
        if (.not.(iparm(14).ge.-2 .and. iparm(14).le.3 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'iuinit' )
                go to 900
        endif
        if (.not.(iparm(15).ge.0  )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'needrc' )
                go to 900
        endif
        if (.not.(iparm(16).ge.0     )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'ns1   ' )
                go to 900
        endif
        if (.not.(iparm(17).ge.1     )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'ns2   ' )
                go to 900
        endif
        if (.not.(iparm(18).ge.-1 .and. iparm(18).le.1 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'ickstg' )
                go to 900
        endif
        if (.not.(iparm(19).ge.0  .and. iparm(19).le.1 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'iuexac' )
                go to 900
        endif
        if (.not.(iparm(20).ge.0    .and. iparm(20).le.1   )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'idot  ' )
                go to 900
        endif
        if (.not.(iparm(21).ge.0  .and. iparm(21).le.1 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'istats' )
                go to 900
        endif
        if (.not.(iparm(26).ge.iparm(24) .and.
     &                      iparm(26).le.iparm(25)        )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'msgtyp' )
                go to 900
        endif
        if (.not.(iparm(27).ge.0   .and. iparm(27).le.2  )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'iclev ' )
                go to 900
        endif
      if (icallr .le. 0) go to 900
*
      relpr = cmch('E',  iparm , fparm , iwk , fwk , ier  )
      if (ier .lt. 0) go to 900
      if (real(fparm(4)) .lt. real(relpr)) then
                ier = 3
                call xersho ( ier, 'cargck' , iparm , ' ' )
      endif
      if (icallr .le. 1) go to 900
*
        if (.not.(iparm(41).ge.0  .and. iparm(41).le.3 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'iscale' )
                go to 900
        endif
        if (.not.(iparm(42).ge.0  .and. iparm(42).le.1 )) then
                ier = -5
                call xersho ( ier, 'cargck' , iparm ,
     &                        'Parameter '//'ictran' )
                go to 900
        endif
      if (icallr .le. 2) go to 900
*
 900  continue
*
      return
      end
