************************************************************************
**  ^ROUTINE: WWSAX - Generalized saxpy routine (^)
**
      subroutine zwsax ( z , y , x , c , iparm , fparm , iwk , fwk , 
     &   ier )
**
**  ^DESCRIPTION:
**    Performs the saxpy operation (alpha x plus y, where alpha is a scalar
**    and x and y are vectors) and places the result in z.  Here the scalar
**    constant value is passed as c (z = c x + y).  The operation is general
**    in that the result is placed into z instead of overwriting y.  This
**    routine is part of the Low-level level-1 BLAS-type routine required by
**    pcg package.  Written for Sun, Cray YMP, Ncube, iPSC 860, or generic
**    f77; as set by m4 variable iPSC860.
**
**    On a Cray YMP the vector is partitioned out to all available processors.
**    The partitioning is done using compiler directives, thus the complier
**    decides how the partitioning is done.
**
**  ^AUTHOR:  wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:14 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**     Basic vector addition and multiplication of a vector by a scalar.
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    BASICAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  BASICAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
           double complex z(*)
           double complex x(*)
           double complex y(*)
      double complex c
      integer nv
      integer i
          integer xptr
          integer yptr
          integer zptr
      double complex cval
      double precision cval2(2)
      equivalence (cval,cval2)
      external zwset
      external zwadd
      external zwsub
          external zcopy
          external zaxpy
          external zscal
          external XREF
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:14 1996 $
*     $Id: wsax.fm4,v 1.10 1994/07/15 19:43:46 joubert Exp $
*     $Revision: 1.10 $
************************************************************************
*-----------------------------------------------------------------------
*--- First check for special cases based on the value of c -------------
*-----------------------------------------------------------------------
      if (c .eq. (0d0,0.0d0)) then
        call zwset ( z , y , iparm , fparm , iwk , fwk , ier )
        go to 910
      endif
      if (c .eq. (1d0,0.0d0)) then
        call zwadd ( z , y , x , iparm , fparm , iwk , fwk , ier )
        go to 910
      endif
      if (c .eq. -(1d0,0.0d0)) then
        call zwsub ( z , y , x , iparm , fparm , iwk , fwk , ier )
        go to 910
      endif
*-----------------------------------------------------------------------
*--- General case: handle different machines----------------------------
*-----------------------------------------------------------------------
      nv = iparm(3)
      cval = c
          call XREF (x,xptr)
          call XREF (y,yptr)
          call XREF (z,zptr)
          if (xptr.eq.zptr .and. yptr.eq.zptr) then
            call zscal (nv,((1d0,0.0d0)+c),z,1)
            fparm(3) = fparm(3) + (6.*nv)
            go to 910
          endif
          if (yptr .eq. zptr) then
            call zaxpy (nv,c,x,1,z,1)
            go to 900
          endif
          if (xptr .eq. zptr) then
             do 8511 i = 1, (nv-(1)+1)/(8)*(8)+1-1, 8
                z((i+0)) = y((i+0)) + c*z((i+0))
                z((i+1)) = y((i+1)) + c*z((i+1))
                z((i+2)) = y((i+2)) + c*z((i+2))
                z((i+3)) = y((i+3)) + c*z((i+3))
                z((i+4)) = y((i+4)) + c*z((i+4))
                z((i+5)) = y((i+5)) + c*z((i+5))
                z((i+6)) = y((i+6)) + c*z((i+6))
                z((i+7)) = y((i+7)) + c*z((i+7))
 8511           continue
                do 8513 i = (nv-(1)+1)/(8)*(8)+1, nv
                z(i) = y(i) + c*z(i)
 8513           continue
            go to 900
          endif
          if (xptr .eq. yptr) then
             do 8515 i = 1, (nv-(1)+1)/(8)*(8)+1-1, 8
                z((i+0)) = ((1d0,0.0d0)+c)*y((i+0))
                z((i+1)) = ((1d0,0.0d0)+c)*y((i+1))
                z((i+2)) = ((1d0,0.0d0)+c)*y((i+2))
                z((i+3)) = ((1d0,0.0d0)+c)*y((i+3))
                z((i+4)) = ((1d0,0.0d0)+c)*y((i+4))
                z((i+5)) = ((1d0,0.0d0)+c)*y((i+5))
                z((i+6)) = ((1d0,0.0d0)+c)*y((i+6))
                z((i+7)) = ((1d0,0.0d0)+c)*y((i+7))
 8515           continue
                do 8517 i = (nv-(1)+1)/(8)*(8)+1, nv
                z(i) = ((1d0,0.0d0)+c)*y(i)
 8517           continue
*           call zcopy (nv,y,1,z,1)
*           call zscal (nv,((1d0,0.0d0)+c),z,1)
            fparm(3) = fparm(3) + (6.*nv)
            go to 910
          endif
           do 8519 i = 1, (nv-(1)+1)/(8)*(8)+1-1, 8
              z((i+0)) = y((i+0)) + c*x((i+0))
              z((i+1)) = y((i+1)) + c*x((i+1))
              z((i+2)) = y((i+2)) + c*x((i+2))
              z((i+3)) = y((i+3)) + c*x((i+3))
              z((i+4)) = y((i+4)) + c*x((i+4))
              z((i+5)) = y((i+5)) + c*x((i+5))
              z((i+6)) = y((i+6)) + c*x((i+6))
              z((i+7)) = y((i+7)) + c*x((i+7))
 8519         continue
              do 8521 i = (nv-(1)+1)/(8)*(8)+1, nv
              z(i) = y(i) + c*x(i)
 8521         continue
*
*-----------------------------------------------------------------------
*--- Final exit---------------------------------------------------------
*-----------------------------------------------------------------------
*
  900 continue
*
      fparm(3) = fparm(3) + (8.*nv)
*
  910 continue
      return
      end
