************************************************************************
**  ^ROUTINE: WWFIL - Routine to fill a vector with a given scalar value.
**                   (^)
**
      subroutine zwfil ( vo , c , iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    The elements of the vector vo are set equal to the value of the scalar c.
**    This routine is part of the Low-level level-1 BLAS-type routine required
**    by pcg package.  Written for Sun, Cray YMP, iPSC 860, NCube, and generic
*#    f77; as set by m4 varialbe MACHINE.
**
**    On a Cray YMP the vector is partitioned out to all available processors.
**    The partitioning is done using compiler directives, thus the complier
**    decides how the partitioning is done.
**
**  ^AUTHOR:  wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:17 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**    Simply the setting of the elements of vo to the value of the scalar c.
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    BASICAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  BASICAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
       double complex vo(*)
      double complex c
      integer nv
      integer i
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:17 1996 $
*     $Id: wfil.fm4,v 1.7 1994/02/04 03:00:02 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
      nv = iparm(3)
           do 8511 i = 1, (nv-(1)+1)/(8)*(8)+1-1, 8
              vo((i+0)) = c
              vo((i+1)) = c
              vo((i+2)) = c
              vo((i+3)) = c
              vo((i+4)) = c
              vo((i+5)) = c
              vo((i+6)) = c
              vo((i+7)) = c
 8511         continue
              do 8513 i = (nv-(1)+1)/(8)*(8)+1, nv
              vo(i) = c
 8513         continue
      return
      end
