************************************************************************
**  ^ROUTINE: WSATOP - Wrapper routine which calls suba with the
**                     appropriate (extended) argument list. (^)
**
      subroutine zsatop ( subx, isetup, ijob , ia , ja , a , vi , vo , 
     &   iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    Wrapper routine which calls subroutine sub with the appropriate
**    (extended) argument list, for the case when the package is called
**    from the top level.  In this case it is desirable to pass down more
**    information than for the simple accelerator-level interface.
**
**    This wrapper routine is used to keep the caller from
**    getting confused by two calls to suba with differing argument lists.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:21 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       sub - local name of matrix-vector multiply routine
**             passed in as argument to this subroutine.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    MVFFAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  ALLAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
       integer ia(*)
       integer ja(*)
       double complex a(*)
       double complex vi(*)
       double complex vo(*)
      integer isetup
      external subx
*
      integer iptr
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:21 1996 $
*     $Id: satop.fm4,v 1.10 1994/04/30 04:40:08 joubert Exp $
*     $Revision: 1.10 $
************************************************************************
*
      iptr = iparm(11)
      iparm(11) = iwk(iptr+isetup)
      call subx ( ijob , ia , ja , a , vi , vo , iwk , fwk , iparm , 
     &   fparm , ier )
      iwk(iptr+isetup) = iparm(11)
      iparm(11) = iptr
           if (ier .lt. 0) go to 900
*
  900 continue
      return
      end
