************************************************************************
**  ^ROUTINE: WRIGR - Preconditioner linking routine,
**                     ri preconditioner, gr format.(^)
**
      subroutine zrigr ( ijob , accel , ia , ja , a , u , uexact , b , 
     &   iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine links in the package routines necessary for the ri
**    preconditioner, gr format, and then passes things down to
**    the routine "prec".
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:22 1996 $
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       WPREC  - routine to actually call preconditioner generator and itmeth
**       WCKRI  - routine to check correctness of the format
**       WSCRI  - scaling routine
**       WMVRI  - matvec routine
**       WRIRIX - preconditioner routine
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    PRECAL            - preconditioner routine arg list
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      external accel
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
       integer ia(*)
       integer ja(*)
       double complex a(*)
       double complex u(*)
       double complex uexact(*)
       double complex b(*)
      external zprec
      external zckgr
      external zscgr
      external zmvgr
      external zrigrx
      call zprec ( zckgr, zscgr, zscgr, zmvgr, zrigrx, ijob , accel , 
     &   ia , ja , a , u , uexact , b , iwk , fwk , iparm , fparm , ier 
     &   )
      return
      end
******^^****************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:22 1996 $
*     $Id: rigr.fm4,v 1.7 1994/02/04 03:03:35 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
