************************************************************************
**  ^ROUTINE: WPCG - Top-level pcg package routine. (^)
**
      subroutine zpcg ( ijob , precon , accel , ia , ja , a , u , 
     &   uexact , b , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This is the main top-level routine of the package.  It does some
**    initializations and then passes everything down to the
**    preconditioner generator.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:24 1996 $
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       WARGCK - Routine to check the validity of iparm and
**                fparm entries on entry to the package.
**       WIFPPR - Routine to print iparm/fparm variables if requested.
**       xtimer - Package timer routine.  Returns cpu time as well as
**                real time.
**       precon - local value of subroutine name of preconditioner passed
**                through as argument to this subroutine.  The precon routine
**                generates the preconditioner and calls the accelerator.
**       accel  - local value of subroutine name for accelerator.
**                Passed down through precon.
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^SIDE_EFFECTS:
**       Solves the linear system.  Modifies u, iparm, fparm, and
**       sometimes others.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    TOPAL             - Top Level arg list.
*#                    !---Subroutine Names as Arguments:
*#                        precon - preconditioning routine usually subq
*#                        accel -  accelerator routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external precon, accel
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
       integer ia(*)
       integer ja(*)
       double complex a(*)
       double complex u(*)
       double complex uexact(*)
       double complex b(*)
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
        integer itimer
        double precision tc1, tr1, tc2, tr2
      external ximini
      external ximal
      external xifre
      external zfmini
      external zfmal
      external zffre
*
      external zargck
      external zifppr
      external xtimer
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:24 1996 $
*     $Id: pcg.fm4,v 1.22 1994/07/06 05:51:46 joubert Exp $
*     $Revision: 1.22 $
************************************************************************
*
      itimer = 0
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (iparm(27) .eq. 0) iparm(27) = 2
      if (iparm(27) .eq. 2) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
      call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call zfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
        call zargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
      if (ijob.ne.1 .and. ijob.ne.2 .and. ijob.ne.-1 .and. ijob.ne.0 
     &   .and. ijob.ne.3 .and. ijob.ne.4 .and. ijob.ne.5) then
                ier = -4
                call xersho ( ier, 'zpcg' , iparm , 'Argument ijob' )
                go to 900
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
      if (iparm(27) .eq. 2) then
        call zifppr ( 1 , iparm, fparm, ier )
           if (ier .lt. 0) go to 900
      endif
*
      call precon ( ijob , accel , ia , ja , a , u , uexact , b , iwk , 
     &   fwk , iparm , fparm , ier )
*
*-------------------------------terminate-------------------------------
*
  900 continue
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(21) = fparm(21) + (tc2-tc1)
        fparm(22) = fparm(22) + (tr2-tr1)
      endif
      if (iparm(27) .eq. 2) then
        call zifppr ( -1 , iparm, fparm, ier )
      endif
*
      if (iparm(27) .eq. 2) iparm(27) = 0
*
      return
      end
