************************************************************************
** ^ROUTINE: WMVUR - Wrapper routine for for the Union of Rectangles (UR)
**                   usage of the workhorse Matrix-vector product
**                   routine WMVGRW.
**                       (^)
      subroutine zmvur ( ijob , ia , ja , a , vi , vo , iwk , fwk , 
     &   iparm , fparm , ier )
**
** ^DESCRIPTION:
**
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED:  wdj@lithos.c3.lanl.gov  Thu Mar  4 13:57:02 MST 1993
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Subroutines: See External declerations below
**    This code requires the include file saip.m4.
**
** ^SIDE_EFFECTS:
**
** ^ALGORITHM:
**
** ^REFERENCES:
**
** ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
************************************************************************
*#    MVFFAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  ALLAL is used in
*#                        calls to fortran routines.
*#
*#                        Integer Scalars:
*#                        ier - (int) error return value.
*#
*#                        Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#
*#                        Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
       integer ia(*)
       integer ja(*)
       double complex a(*)
       double complex vi(*)
       double complex vo(*)
*
************************************************************************
*
      external zmvgrw
************************************************************************
*
************************************************************************
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:28 1996 $
*     $Id: mvur.fm4,v 1.4 1994/02/18 08:50:27 joubert Exp $
*     $Revision: 1.4 $
*     $Log: mvur.fm4,v $
*     Revision 1.4  1994/02/18  08:50:27  joubert
*     mpi, t3dpvm versions completed; misc other changes
*
*     Revision 1.3  1994/02/04  03:03:16  joubert
*          .
*
*     Revision 1.3  94/02/01  09:55:58  wdj
*
*
*     Revision 1.2  1994/01/05  13:21:26  kohli
*     Created Mat-vec workhorse file mvgrw
*
*     Revision 1.1  1993/12/20  22:03:32  joubert
*     integration of UR format into package
*
*     Revision 1.1  1993/12/17  17:34:36  kohli
*     Adding mat vec files for Union of Rectangles.
*
*     Revision 1.14  1993/12/07  05:11:08  joubert
*     misc minor changes; revision of mvgr.fm4
*
*     Revision 1.13  1993/12/04  09:07:43  joubert
*     mainly mods to iPSC/Paragon
*
*     Revision 1.12  1993/09/25  02:46:52  joubert
*     fixed some memory problems in the revcom layer
*
*     Revision 1.11  1993/09/17  23:08:44  joubert
*     Minor mods
*
*     Revision 1.10  1993/09/17  22:27:07  mclay
*     Fixed F FREE to I FREE for mbufl and mbufp
*
*     Revision 1.9  1993/09/16  23:42:51  joubert
*     pure cmf routines added; mods to testt2d; testr2d partly written
*
*     Revision 1.8  1993/09/14  02:27:41  mclay
*     Removed residual memory calculations.
*
*     Revision 1.7  1993/08/24  06:51:23  joubert
*     Changed ia/a to ia/ja/a.
*
*     Revision 1.6  1993/08/04  22:49:24  joubert
*     Installed split diagonal scaling
*
*     Revision 1.5  1993/07/24  00:36:26  joubert
*     Fixed problems with transpose matvec
*
*     Revision 1.4  1993/07/23  18:50:21  joubert
*     Installed transpose matvec for GR format
*
*     Revision 1.3  1993/07/21  19:51:08  joubert
*     Work on matrix scaling
*
*     Revision 1.2  1993/07/12  22:40:46  joubert
*     hacker's manual updates; changed names for some arglist macros
*
*     Revision 1.1  1993/07/09  06:25:03  joubert
*     Minor design changes; new matrix format nomenclature
*
*     Revision 1.4  1993/06/25  20:13:49  joubert
*     New round of interface design changes
*
*     Revision 1.3  1993/05/19  07:27:10  joubert
*     cosmetic changes; fixed Ncube and cmmd versions
*
*     Revision 1.2  1993/05/05  19:28:37  joubert
*     overhauled matvec/precon interface;
*     new directory structure for grid directories
*
*     Revision 1.2  1993/04/30  23:23:15  joubert
*     cosmetic changes / iparm name changes / set-io-mode improvements
*
*     Revision 1.1  1993/04/30  03:06:10  mclay
*
************************************************************************
*
       call zmvgrw ( 1, ijob , ia , ja , a , vi , vo , iwk , fwk , 
     &    iparm , fparm , ier )
*
      return
      end
*-----------------------------------------------------------------------
