************************************************************************
**  ^ROUTINE: WMSTRT - Initialization routine for the 0 malloc routine
**                     for floating arrays. (^)
**
      subroutine zmstrt (fwk,size,ier)
**  ^DESCRIPTION:  This routine initializes the array so it can be used
**      by the allocation routine.  The array is setup as follows:
**         fwk(1)        = rover     ! The first Void (rover)
**         fwk(2)        = 1         ! if 1 then the array has been initialed
**         fwk(3)        = nvoids    ! The number of nvoids
**         fwk(9-1) = -1        ! Barrier
**         fwk(9)   = voidsize  ! size of block
**         fwk(size-1)   = voidsize  ! size of block
**         fwk(size)     = -1        ! Barrier
**
**      NOTE:  This routine uses an equivalence trick to save the integer
**             values in a floating point location
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Mon Jul 19 21:21:10 1993
**
**  ^MODIFIED: mclay@vato.ae.utexas.edu on Tue Sep  7 14:03:09 1993 $
**
**  ^REQUIREMENTS:  That the size is correct.
**
**
**  ^SIDE_EFFECTS:  The locations of fwk are changed as shown above.
**
**  ^ALGORITHM:     The array is a "next fit" allocation scheme
**
**  ^MACROS_USED:
*#    FTYPE - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    ISTART - (^)
*#    NSIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    SAVE - (^)
*#    WMEMCK - (^)
*#    WMSTRT - (^)
*#    WNAME - (^)
**
****^^******************************************************************
*
      implicit none
*
      integer size
       double complex fwk(*)
      integer ier
*
      integer itmp
      integer nuser
      integer nvoids
      integer vdsize
      logical rtn
*
         integer memtmp
         integer mtmp2
      integer iequiv
      double complex requiv
      equivalence (iequiv,requiv)
*
      logical zmemck
      external zmemck
*
****^^******************************************************************
*     $Modified: mclay@vato.ae.utexas.edu on Tue Sep  7 14:03:09 1993 $
*     $Id: mstrt.fm4,v 1.8 1994/05/10 01:20:39 joubert Exp $
*     $Revision: 1.8 $
*     $Log: mstrt.fm4,v $
*     Revision 1.8  1994/05/10  01:20:39  joubert
*     fixed memory allocator errors
*
*     Revision 1.7  1994/04/30  04:40:02  joubert
*     improved error handling
*
*     Revision 1.6  1994/04/29  23:53:17  joubert
*     added tfqmr method
*
*     Revision 1.5  1994/04/22  03:30:46  joubert
*     fixed bug in c memory allocator
*
*     Revision 1.4  1994/04/21  04:18:48  joubert
*     debugged YMP version
*
*     Revision 1.1  1993/09/28  16:26:29  joubert
*     Implemented IPARM variable 15
*
*     Revision 1.2  1993/09/14  02:24:04  mclay
*     Corrected memory allocations routines.
*
*     Revision 1.1  1993/08/24  16:08:01  mclay
*     New 0 malloc routines.
*
************************************************************************
*
      vdsize = size - 9
      nvoids = 1
      nuser = 0
      if (size .lt. 13) then
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['fwk too small'])
      endif
      requiv=fwk(4)
      itmp=iequiv
**#   if (itmp == INITIALIZE) then
**#     ier = ERRMEM
**#     go to CLEANUP_LABEL
**#     HANDLE_ERROR(ERRMEM,['Re-initializating memory allocator'])
**#   endif
      iequiv=9
      fwk(3) =requiv
      iequiv=4
      fwk(4) =requiv
      iequiv=nvoids
      fwk(5) =requiv
      iequiv=nuser
      fwk(6) =requiv
      iequiv=size
      fwk(7) =requiv
*
      iequiv=-1
      fwk(9-1) =requiv
      iequiv=vdsize
      fwk(9) =requiv
      iequiv=9
      fwk(9+1) =requiv
      iequiv=9
      fwk(9+2) =requiv
      iequiv=vdsize
      fwk(size-1) =requiv
      iequiv=-1
      fwk(size) =requiv
*
      iequiv=9
      fwk(1) =requiv
      iequiv=9
      fwk(2) =requiv
*
      rtn = zmemck (fwk)
      if (.not.rtn) then
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Re-initializing memory'])
      endif
*
  900 continue
      return
      end
