************************************************************************
**  ^ROUTINE: WGLMIN - Global elementwise minimum of vectors.
**                       (^)
**
      subroutine zglmin ( nelts, vec, vwork, iparm , fparm , iwk , fwk ,
     &    ier )
**
**  ^DESCRIPTION:
**
**    This routine computes the elementwise global minimum of the real part
**    of elements in the vector vec.
**    For 1\leq i\leq nelts, dble(vec(i)) is globally minimized across
**    processors.  The resulting quantity is real.
**    vwork is a work vector of the same dimension as vec.
**    This is a global operation and therefore must be executed on
**    all nodes before execution may continue.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:42 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS: vwork is a work array
**
**  ^ALGORITHM:
**    Chosen from the following:
**      - Bidirectional exchange
**      - Send all to node zero, operate, broadcast
**      - System subroutine call
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
*#    BASICAL - (^)
       double complex vwork(*)
       double complex vec(*)
      integer nelts
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer i
      integer ineqv
      external ineqv
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:42 1996 $
*     $Id: glmin.fm4,v 1.9 1994/04/30 04:39:11 joubert Exp $
*     $Revision: 1.9 $
************************************************************************
*
      if (nelts .le. 0) return
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
          call gdlow (vec,nelts*2,vwork)
  900 continue
      return
      end
