************************************************************************
**  ^ROUTINE: WGLMAX - Global elementwise maximum of vectors.
**                       (^)
**
      subroutine zglmax ( nelts, vec, vwork, iparm , fparm , iwk , fwk ,
     &    ier )
**
**  ^DESCRIPTION:
**
**    This routine computes the elementwise global maximum of the real part
**    of elements in the vector vec.
**    For 1\leq i\leq nelts, dble(vec(i)) is globally maximized across
**    processors.  The resulting quantity is real.
**    vwork is a work vector of the same dimension as vec.
**    This is a global operation and therefore must be executed on
**    all nodes before execution may continue.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:42 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS: vwork is a work array
**
**  ^ALGORITHM:
**    Chosen from the following:
**      - Bidirectional exchange
**      - Send all to node zero, operate, broadcast
**      - System subroutine call
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
*#    BASICAL - (^)
*
       double complex vwork(*)
       double complex vec(*)
      integer nelts
*
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
*
      integer i
*
*
      integer ineqv
      external ineqv
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:42 1996 $
*     $Id: glmax.fm4,v 1.7 1994/04/30 04:39:09 joubert Exp $
*     $Revision: 1.7 $
*     $Log: glmax.fm4,v $
*     Revision 1.7  1994/04/30  04:39:09  joubert
*     improved error handling
*
*     Revision 1.6  1994/03/27  10:28:33  ak
*     Added code for Express on RS6000
*
*     Revision 1.5  1994/02/18  08:49:10  joubert
*     mpi, t3dpvm versions completed; misc other changes
*
*     Revision 1.4  1994/02/04  02:59:50  joubert
*          .
*
*     Revision 1.4  94/02/01  09:52:40  wdj
*
*
*     Revision 1.3  1993/12/09  04:07:45  joubert
*     debugged Paragon version
*
*     Revision 1.2  1993/12/04  09:06:46  joubert
*     mainly mods to iPSC/Paragon
*
*     Revision 1.1  1993/09/17  22:25:11  mclay
*     Global element maximum.
*
*
************************************************************************
*
      if (nelts .le. 0) return
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
*
          call gdhigh (vec,nelts*2,vwork)
*
  900 continue
*
      return
      end
