************************************************************************
**  ^ROUTINE: WFMAL - routine to allocate floating point memory. (^)
**
      subroutine zfmal ( iptr, nwords, iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    This routine is the general purpose floating point memory allocator.
**    it calls either the Fortran or the **    error checking.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    BASICAL - (^)
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
      integer iptr
      integer nwords
*
         integer memtmp
         integer mtmp2
      integer fused
      integer imem
*     external imem
      integer zmem
*     external zmem
      integer iequiv
      double complex requiv
      equivalence (iequiv,requiv)
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:44 1996 $
*     $Id: fmal.fm4,v 1.1 1994/04/21 01:37:12 joubert Exp $
************************************************************************
*
      iptr = (iparm(6))
      if (nwords .le. 0) go to 900
*
         if (iparm(6) .eq. 1) then
           call zfmalloc (fwk,nwords,iptr)
           requiv=fwk(1)
           fused=iequiv
           fused = fused + (nwords) + 2
           iequiv=fused
           fwk(1)=requiv
           iparm(10) = max(iparm(10),fused)
         else
           iptr = zmem (fwk,nwords)
           requiv=fwk(1)
           fused=iequiv
           fused = fused + (nwords) + 2
           iequiv=fused
           fwk(1)=requiv
           iparm(10) = max(iparm(10),fused)
*
         endif
         memtmp = 1 - min(1,iabs(iptr-(iparm(6))))
         call xgladd (1,memtmp,mtmp2, iparm , fparm , iwk , fwk , ier )
         if (memtmp .ne. 0) then
                ier = -3
                call xersho ( ier, 'zfmal' , iparm , 900 )
                go to 900
         endif
*
  900 continue
*
      return
      end
