************************************************************************
**  ^ROUTINE: WCKSTG - routine to check for stagnation of the iterative
**                     method. (^)
**
      subroutine zckstg ( iclstg, iwkstg, iparm , fparm , iwk , fwk , 
     &   ier )
**
**  ^DESCRIPTION:
**    This routine is called in association with the stopping test.
**    The current convergence parameter stptst is monitored from
**    iteration to iteration, and if it does not change appreciably
**    for a sequence of iterations, stagnation is flagged and,
**    depending on the appropriate iparm setting, an error return
**    occurs.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:45 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    BASICAL - (^)
      integer ier
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
      external ximini
      external ximal
      external xifre
      external zfmini
      external zfmal
      external zffre
      integer iclstg
      integer iwkstg
      integer i
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:45 1996 $
*     $Id: ckstg.fm4,v 1.15 1994/09/28 19:24:17 joubert Exp $
*     $Revision: 1.15 $
************************************************************************
*
      if (iparm(12) .eq. 0) return
*
      if (iparm(18) .eq. 0) return
*
      if (iclstg .eq. 1) then
      call zfmal (iwkstg,20, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      endif
*
      if (iclstg .eq. -1) then
      call zffre (iwkstg,20, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        go to 900
      endif
*
      if (iclstg .lt. 20) go to 100
      do 8511 i = iclstg-1, iclstg-20+1, -1
        if (dble(abs(fwk(iwkstg+mod(i,20))-fparm(5))) .gt. 1.e-4*dble(
     &     fparm(5))) go to 100
 8511 continue
*
                ier = -8
                call xersho ( ier, 'zckstg' , iparm , ' ' )
                go to 900
*
  100 continue
*
      fwk(iwkstg+mod(iclstg,20)) = fparm(5)
      iclstg = iclstg + 1
*
  900 continue
*
      return
      end
