************************************************************************
**  ^ROUTINE: zchad - Hadamard product, conjugating one vector. (^)
**
      subroutine zchad (n,z,iz,a,ia,x,ix)
**
**  ^DESCRIPTION:
**
**    Computes z = z + conjg(a)*x
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:46 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED: see below.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
      integer n
      integer iz, ia, ix
          double complex z(*), a(*), x(*)
      integer i
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:46 1996 $
*     $Id: chad.fm4,v 1.8 1994/07/15 19:44:02 joubert Exp $
*     $Revision: 1.8 $
************************************************************************
          if (iz.eq.1 .and. ia.eq.1 .and. ix.eq.1) then
             do 8511 i = 1, (n-(1)+1)/(8)*(8)+1-1, 8
             z((i+0)) = z((i+0)) + conjg(a((i+0)))*x((i+0))
             z((i+1)) = z((i+1)) + conjg(a((i+1)))*x((i+1))
             z((i+2)) = z((i+2)) + conjg(a((i+2)))*x((i+2))
             z((i+3)) = z((i+3)) + conjg(a((i+3)))*x((i+3))
             z((i+4)) = z((i+4)) + conjg(a((i+4)))*x((i+4))
             z((i+5)) = z((i+5)) + conjg(a((i+5)))*x((i+5))
             z((i+6)) = z((i+6)) + conjg(a((i+6)))*x((i+6))
             z((i+7)) = z((i+7)) + conjg(a((i+7)))*x((i+7))
 8511        continue
             do 8513 i = (n-(1)+1)/(8)*(8)+1, n
             z(i) = z(i) + conjg(a(i))*x(i)
 8513        continue
          else if (iz.eq.1 .and. ix.eq.1) then
             do 8515 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+(i+0)) = z(1+(i+0)) + conjg(a(1+((i+0))*ia))*x(1+(i+0))
             z(1+(i+1)) = z(1+(i+1)) + conjg(a(1+((i+1))*ia))*x(1+(i+1))
             z(1+(i+2)) = z(1+(i+2)) + conjg(a(1+((i+2))*ia))*x(1+(i+2))
             z(1+(i+3)) = z(1+(i+3)) + conjg(a(1+((i+3))*ia))*x(1+(i+3))
             z(1+(i+4)) = z(1+(i+4)) + conjg(a(1+((i+4))*ia))*x(1+(i+4))
             z(1+(i+5)) = z(1+(i+5)) + conjg(a(1+((i+5))*ia))*x(1+(i+5))
             z(1+(i+6)) = z(1+(i+6)) + conjg(a(1+((i+6))*ia))*x(1+(i+6))
             z(1+(i+7)) = z(1+(i+7)) + conjg(a(1+((i+7))*ia))*x(1+(i+7))
 8515        continue
             do 8517 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+i) = z(1+i) + conjg(a(1+(i)*ia))*x(1+i)
 8517        continue
          else if (iz.eq.1 .and. ia.eq.1) then
             do 8519 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+(i+0)) = z(1+(i+0)) + conjg(a(1+(i+0)))*x(1+((i+0))*ix)
             z(1+(i+1)) = z(1+(i+1)) + conjg(a(1+(i+1)))*x(1+((i+1))*ix)
             z(1+(i+2)) = z(1+(i+2)) + conjg(a(1+(i+2)))*x(1+((i+2))*ix)
             z(1+(i+3)) = z(1+(i+3)) + conjg(a(1+(i+3)))*x(1+((i+3))*ix)
             z(1+(i+4)) = z(1+(i+4)) + conjg(a(1+(i+4)))*x(1+((i+4))*ix)
             z(1+(i+5)) = z(1+(i+5)) + conjg(a(1+(i+5)))*x(1+((i+5))*ix)
             z(1+(i+6)) = z(1+(i+6)) + conjg(a(1+(i+6)))*x(1+((i+6))*ix)
             z(1+(i+7)) = z(1+(i+7)) + conjg(a(1+(i+7)))*x(1+((i+7))*ix)
 8519        continue
             do 8521 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+i) = z(1+i) + conjg(a(1+i))*x(1+(i)*ix)
 8521        continue
          else if (ix.eq.1 .and. ia.eq.1) then
             do 8523 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+((i+0))*iz) = z(1+(i+0)*iz) + conjg(a(1+(i+0)))*x(1+(i+
     &          0))
             z(1+((i+1))*iz) = z(1+(i+1)*iz) + conjg(a(1+(i+1)))*x(1+(i+
     &          1))
             z(1+((i+2))*iz) = z(1+(i+2)*iz) + conjg(a(1+(i+2)))*x(1+(i+
     &          2))
             z(1+((i+3))*iz) = z(1+(i+3)*iz) + conjg(a(1+(i+3)))*x(1+(i+
     &          3))
             z(1+((i+4))*iz) = z(1+(i+4)*iz) + conjg(a(1+(i+4)))*x(1+(i+
     &          4))
             z(1+((i+5))*iz) = z(1+(i+5)*iz) + conjg(a(1+(i+5)))*x(1+(i+
     &          5))
             z(1+((i+6))*iz) = z(1+(i+6)*iz) + conjg(a(1+(i+6)))*x(1+(i+
     &          6))
             z(1+((i+7))*iz) = z(1+(i+7)*iz) + conjg(a(1+(i+7)))*x(1+(i+
     &          7))
 8523        continue
             do 8525 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+(i)*iz) = z(1+i*iz) + conjg(a(1+i))*x(1+i)
 8525        continue
          else if (iz.eq.1) then
             do 8527 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+(i+0)) = z(1+(i+0)) + conjg(a(1+((i+0))*ia))*x(1+((i+0)
     &          )*ix)
             z(1+(i+1)) = z(1+(i+1)) + conjg(a(1+((i+1))*ia))*x(1+((i+1)
     &          )*ix)
             z(1+(i+2)) = z(1+(i+2)) + conjg(a(1+((i+2))*ia))*x(1+((i+2)
     &          )*ix)
             z(1+(i+3)) = z(1+(i+3)) + conjg(a(1+((i+3))*ia))*x(1+((i+3)
     &          )*ix)
             z(1+(i+4)) = z(1+(i+4)) + conjg(a(1+((i+4))*ia))*x(1+((i+4)
     &          )*ix)
             z(1+(i+5)) = z(1+(i+5)) + conjg(a(1+((i+5))*ia))*x(1+((i+5)
     &          )*ix)
             z(1+(i+6)) = z(1+(i+6)) + conjg(a(1+((i+6))*ia))*x(1+((i+6)
     &          )*ix)
             z(1+(i+7)) = z(1+(i+7)) + conjg(a(1+((i+7))*ia))*x(1+((i+7)
     &          )*ix)
 8527        continue
             do 8529 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+i) = z(1+i) + conjg(a(1+(i)*ia))*x(1+(i)*ix)
 8529        continue
          else if (ix.eq.1) then
             do 8531 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+((i+0))*iz) = z(1+((i+0))*iz) + conjg(a(1+((i+0))*ia))*
     &          x(1+(i+0))
             z(1+((i+1))*iz) = z(1+((i+1))*iz) + conjg(a(1+((i+1))*ia))*
     &          x(1+(i+1))
             z(1+((i+2))*iz) = z(1+((i+2))*iz) + conjg(a(1+((i+2))*ia))*
     &          x(1+(i+2))
             z(1+((i+3))*iz) = z(1+((i+3))*iz) + conjg(a(1+((i+3))*ia))*
     &          x(1+(i+3))
             z(1+((i+4))*iz) = z(1+((i+4))*iz) + conjg(a(1+((i+4))*ia))*
     &          x(1+(i+4))
             z(1+((i+5))*iz) = z(1+((i+5))*iz) + conjg(a(1+((i+5))*ia))*
     &          x(1+(i+5))
             z(1+((i+6))*iz) = z(1+((i+6))*iz) + conjg(a(1+((i+6))*ia))*
     &          x(1+(i+6))
             z(1+((i+7))*iz) = z(1+((i+7))*iz) + conjg(a(1+((i+7))*ia))*
     &          x(1+(i+7))
 8531        continue
             do 8533 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+(i)*iz) = z(1+(i)*iz) + conjg(a(1+(i)*ia))*x(1+i)
 8533        continue
          else if (ia.eq.1) then
             do 8535 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+((i+0))*iz) = z(1+((i+0))*iz) + conjg(a(1+(i+0)))*x(1+(
     &          (i+0))*ix)
             z(1+((i+1))*iz) = z(1+((i+1))*iz) + conjg(a(1+(i+1)))*x(1+(
     &          (i+1))*ix)
             z(1+((i+2))*iz) = z(1+((i+2))*iz) + conjg(a(1+(i+2)))*x(1+(
     &          (i+2))*ix)
             z(1+((i+3))*iz) = z(1+((i+3))*iz) + conjg(a(1+(i+3)))*x(1+(
     &          (i+3))*ix)
             z(1+((i+4))*iz) = z(1+((i+4))*iz) + conjg(a(1+(i+4)))*x(1+(
     &          (i+4))*ix)
             z(1+((i+5))*iz) = z(1+((i+5))*iz) + conjg(a(1+(i+5)))*x(1+(
     &          (i+5))*ix)
             z(1+((i+6))*iz) = z(1+((i+6))*iz) + conjg(a(1+(i+6)))*x(1+(
     &          (i+6))*ix)
             z(1+((i+7))*iz) = z(1+((i+7))*iz) + conjg(a(1+(i+7)))*x(1+(
     &          (i+7))*ix)
 8535        continue
             do 8537 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+(i)*iz) = z(1+(i)*iz) + conjg(a(1+i))*x(1+(i)*ix)
 8537        continue
          else
             do 8539 i = 0, (n-1-(0)+1)/(8)*(8)+0-1, 8
             z(1+((i+0))*iz) = z(1+((i+0))*iz) + conjg(a(1+((i+0))*ia))*
     &          x(1+((i+0))*ix)
             z(1+((i+1))*iz) = z(1+((i+1))*iz) + conjg(a(1+((i+1))*ia))*
     &          x(1+((i+1))*ix)
             z(1+((i+2))*iz) = z(1+((i+2))*iz) + conjg(a(1+((i+2))*ia))*
     &          x(1+((i+2))*ix)
             z(1+((i+3))*iz) = z(1+((i+3))*iz) + conjg(a(1+((i+3))*ia))*
     &          x(1+((i+3))*ix)
             z(1+((i+4))*iz) = z(1+((i+4))*iz) + conjg(a(1+((i+4))*ia))*
     &          x(1+((i+4))*ix)
             z(1+((i+5))*iz) = z(1+((i+5))*iz) + conjg(a(1+((i+5))*ia))*
     &          x(1+((i+5))*ix)
             z(1+((i+6))*iz) = z(1+((i+6))*iz) + conjg(a(1+((i+6))*ia))*
     &          x(1+((i+6))*ix)
             z(1+((i+7))*iz) = z(1+((i+7))*iz) + conjg(a(1+((i+7))*ia))*
     &          x(1+((i+7))*ix)
 8539        continue
             do 8541 i = (n-1-(0)+1)/(8)*(8)+0, n-1
             z(1+(i)*iz) = z(1+(i)*iz) + conjg(a(1+(i)*ia))*x(1+(i)*ix)
 8541        continue
          endif
      return
      end
