************************************************************************
**  ^ROUTINE: WCGNR - cgnr iterative method, direct
**                        communication interface. (^)
**
      subroutine zcgnr ( ijob , suba , ia , ja , a , subq , iq , jq , q 
     &   , u , uexact , b , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine interfaces the cgnr revcom routine via the wmeth interface
*     routine in order to apply the iterative method.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    Preconditioned cgnr iterative method
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHAL           - accelerator arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external suba, subq
       integer iwk(*)
       integer iparm(*)
       double complex fwk(*)
       double complex fparm(*)
       integer ia(*)
       integer ja(*)
       integer iq(*)
       integer jq(*)
       double complex a(*)
       double complex q(*)
       double complex u(*)
       double complex uexact(*)
       double complex b(*)
*
      external zmeth
      external zcgnrr
*
      call zmeth ( zcgnrr , ijob , suba , ia , ja , a , subq , iq , jq ,
     &    q , u , uexact , b , iwk , fwk , iparm , fparm , ier )
*
      return
      end
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:52 1996 $
*     $Id: cgnr.fm4,v 1.1 1994/06/14 16:31:21 joubert Exp $
*     $Revision: 1.1 $
*     $Log: cgnr.fm4,v $
*     Revision 1.1  1994/06/14  16:31:21  joubert
*     added normal equations methods
*
************************************************************************
