************************************************************************
**  ^ROUTINE: xtimer - Package timer routine.  Returns cpu time as well as
**                     real time.  (^)
**
      subroutine xtimer ( tcpu , treal , itimer , init )
**
**  ^DESCRIPTION:
**    Package timer routine.  Returns cpu time as well as real
**    time. For the generic Fortran 77 version, the installer should edit this
**    file (the .fm4 file or the .f file) to utilize available system-specific
**    routines.  Note that times are always double precision.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:57 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
*     Subroutines: see IFELSE structure to see machine specific subroutine
**       calls.
**
**  ^SIDE_EFFECTS: modifies tcpu, treal.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
      integer init
      integer itimer
      double precision tcpu, treal
*
*
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:57 1996 $
*     $Id: xtimer.fm4,v 1.12 1994/09/06 17:34:40 joubert Exp $
*     $Revision: 1.12 $
************************************************************************
*
         if (init .eq. 1) return
         tcpu = dclock ()
         treal = tcpu
      return
      end
