************************************************************************
** ^ROUTINE: xslur  - Routine to compute the information for the box
**                    intersection slice.  The coordinates and size of the
**                    intersection of the subgrids is computed, as well as
**                    the processor number of where it is. (^)
**
      subroutine xslur ( ia, ja, isten, islice, ijob, ilbs, ilbd, inelt,
     &    ncelts , ipme, ipsend, iprecv, ipsofs )
**
** ^DESCRIPTION:
**      For each stencil point in a finite difference operator operating
**    over a rectangular subgrid, a perturbed grid is obtained that is
**    spread over upto 2**ndim subgrids (ndim is the number of dimensions
**    in the problem, = 2 for a 2D problem, etc.) The portions of this
**    perturbed subgrid that lie in each of the 2**ndim subgrids are
**    referred to here as slices.
**
**      The purpose of this routine is to determine the location and
**    size of a particular slice islice, and for mimd machines, to
**    determine send and receive processor numbers.
**
**      Several numbering schemes are used to describe slices, subgrids,
**    gridpoints, etc. These are described in the header for "sagrd.fm4".
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Wed Mar  1 10:34:35 1995 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**    See description in "sagrd.fm4" for more details.
**
***********************************************************************
*
      implicit none
*
      integer isten
      integer islice
      integer ijob
      integer ncelts
          integer ipme
          integer ipsend
          integer iprecv
      integer ia(*)
      integer ja(*)
      integer ilbs(*)
      integer ilbd(*)
      integer inelt(*)
          integer ipsofs(*)
*
      integer iaxis
      integer idofst
      integer ipofst
      integer nsten
      integer nb
      integer ncelax
      integer ndim
      integer nelsax
          integer nelax
          integer ismeax
          integer iaofst
          integer issax
          integer israx
          integer nbors
          integer ip_ns
          integer ip_nr
          integer imi2 (32)
          integer imi3 (32)
          integer rng (32)
**#   OFFSTN - magnitude of maximum offset along -ve axial direction in user's
**    definition of neighborhood information
**#   OFFSTP - magnitude of maximum offset along +ve axial direction in user's
**#    definition of neighborhood information.
**#   NBR - processor number of processor in the $1 position in the
**#    neighborhood of the $2 processor as defined by the user.
*
      integer imodf
      external imodf
      integer ifloor
      external ifloor
          integer imi2i
          external imi2i
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Wed Mar  1 10:34:35 1995 $
*     $Id: xslur.fm4,v 1.5 1994/07/20 18:20:40 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
*
      ndim = ia(1)
      nsten = ia(2)
      nb = ia(3)
      ncelts = 1
          ipsend = 0
          iprecv = 0
*
      do 8511 iaxis = 1, ndim
        if (ijob .eq. 3) then
          idofst = ja(iaxis+ndim*(isten-1))
        else
          idofst = -ja(iaxis+ndim*(isten-1))
        endif
*
        nelsax = ja(iaxis+ndim*nsten)
        ipofst = mod(islice/2**(iaxis-1),2)
        if (ipofst .eq. 0) then
          ncelax = nelsax - imodf(idofst,nelsax)
        else
          ncelax = imodf(idofst,nelsax)
        endif
        ncelts = ncelts * ncelax
        if (ncelax .eq. 0) return
        inelt(iaxis) = ncelax
*
        if (ipofst .eq. 0) then
          ilbs(iaxis) = imodf(idofst,nelsax)
        else
          ilbs(iaxis) = 0
        endif
        if (ipofst .eq. 0) then
          ilbd(iaxis) = 0
        else
          ilbd(iaxis) = nelsax - imodf(idofst,nelsax)
        endif
*
           iaofst = ifloor(idofst,nelsax)
           ipsofs(iaxis) = -(ipofst + iaofst)
 8511 continue
          nbors = 1
          do 8513 iaxis = 1,ndim
            rng(iaxis) = ja(iaxis + ndim*(nsten+4)) - ja(iaxis + ndim*(
     &         nsten+3)) + 1
            nbors = nbors*rng(iaxis)
            imi3(iaxis) = -ja(iaxis + ndim*(nsten+3))
 8513     continue
           do 8515 iaxis = 1, ndim
      imi2(iaxis) = imi3(iaxis) + ipsofs(iaxis)
 8515 continue
          ip_ns = imi2i(imi2,ndim,rng)
          ipsend = ja(1 + ip_ns + (nsten+5)*ndim)
           do 8517 iaxis = 1, ndim
      imi2(iaxis) = imi3(iaxis) - ipsofs(iaxis)
 8517 continue
          ip_nr = imi2i(imi2,ndim,rng)
          iprecv = ja(1 + ip_nr + (nsten+5)*ndim)
c          if(ipme.eq.7)then
c            print*,'ipme,isten,islice,iaxis,ipsend,iprecv'
c            print*,'ipme,ipsofs(1),ipsofs(2)'
c            print*,ipme,isten,islice,iaxis,ipsend,iprecv
c            print*,ipme,ipsofs(1),ipsofs(2)
c          endif
*
*---done---------------------------------------------------------------
      return
      end
