************************************************************************
** ^ROUTINE: xslice - Routine to compute the information for the box
**                    intersection slice.  The coordinates and size of the
**                    intersection of the subgrids is computed, as well as
**                    the processor number of where it is. (^)
**
      subroutine xslice ( ia, ja, isten, islice, ijob, ilbs, ilbd, 
     &   inelt, ncelts , ipme, ipsend, iprecv, ipsofs )
**
** ^DESCRIPTION:
**      For each stencil point in a finite difference operator operating
**    over a rectangular subgrid, a perturbed grid is obtained that is
**    spread over upto 2**ndim subgrids (ndim is the number of dimensions
**    in the problem, = 2 for a 2D problem, etc.) The portions of this
**    perturbed subgrid that lie in each of the 2**ndim subgrids are
**    referred to here as slices.
**
**      The purpose of this routine is to determine the location and
**    size of a particular slice islice, and for mimd machines, to
**    determine send and receive processor numbers.
**
**      Several numbering schemes are used to describe slices, subgrids,
**    gridpoints, etc. These are described in the header for "sagrd.fm4".
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:57 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**    See description in "sagrd.fm4" for more details.
**
***********************************************************************
*
      implicit none
*
      integer isten
      integer islice
      integer ijob
      integer ncelts
          integer ipme
          integer ipsend
          integer iprecv
      integer ia(*)
      integer ja(*)
      integer ilbs(*)
      integer ilbd(*)
      integer inelt(*)
          integer ipsofs(*)
*
      integer iaxis
      integer idofst
      integer ipofst
      integer nsten
      integer nb
      integer ncelax
      integer ndim
      integer nelsax
          integer iprdax
          integer npax
          integer nelax
          integer ismeax
          integer iaofst
          integer issax
          integer israx
*
      integer imodf
      external imodf
      integer ifloor
      external ifloor
         integer iproc
         external iproc
         integer igrid
         external igrid
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:57 1994 $
*     $Id: xslice.fm4,v 1.10 1994/07/20 18:20:38 joubert Exp $
*     $Revision: 1.10 $
************************************************************************
*
      ndim = ia(1)
      nsten = ia(2)
      nb = ia(3)
*
      ncelts = 1
          ipsend = 0
          iprecv = 0
          iprdax = 1
*
      do 8511 iaxis = 1, ndim
        if (ijob .eq. 3) then
          idofst = ja(iaxis+ndim*(isten-1))
        else
          idofst = -ja(iaxis+ndim*(isten-1))
        endif
        nelsax = ja(iaxis+ndim*nsten)
        ipofst = mod(islice/2**(iaxis-1),2)
        if (ipofst .eq. 0) then
          ncelax = nelsax - imodf(idofst,nelsax)
        else
          ncelax = imodf(idofst,nelsax)
        endif
        ncelts = ncelts * ncelax
        if (ncelax .eq. 0) return
        inelt(iaxis) = ncelax
        if (ipofst .eq. 0) then
          ilbs(iaxis) = imodf(idofst,nelsax)
        else
          ilbs(iaxis) = 0
        endif
        if (ipofst .eq. 0) then
          ilbd(iaxis) = 0
        else
          ilbd(iaxis) = nelsax - imodf(idofst,nelsax)
        endif
            npax = ja(iaxis+ndim*(nsten+1))
            nelax = nelsax*npax
           ismeax = igrid(imodf(ipme/iprdax,npax)*iprdax,ndim, ja(1+
     &        ndim*(nsten+1)))/iprdax
           iaofst = ifloor(idofst,nelsax)
           issax = ismeax - (ipofst + iaofst)
           ipsend = ipsend + iproc(imodf(issax ,npax)*iprdax,ndim, ja(1+
     &        ndim*(nsten+1)))
           israx = ismeax + (ipofst + iaofst)
           iprecv = iprecv + iproc(imodf(israx ,npax)*iprdax,ndim, ja(1+
     &        ndim*(nsten+1)))
           ipsofs(iaxis) = -(ipofst + iaofst)
           iprdax = iprdax * npax
 8511 continue
*
* ---done---------------------------------------------------------------
      return
      end
