************************************************************************
** ^ROUTINE: xplane - Find the relevant data for the first
**                    nondegenerate plane to cut through a
**                    subbox of a box. (^)
**
      subroutine xplane ( ineltb, inelts, ia, iparm, iaxin1, iaxin2, 
     &   istrd1, istrd2, nin1, nin2, ivstrr, ivstr1, ivstr2, imstrr, 
     &   imstrc, imstr1, imstr2)
**
** ^DESCRIPTION:
**    It is assumed that a (sub) box of size described by inelts is
**    contained in a larger box of size given by ineltb.  The lowest
**    2-D plane of the sub box is found, with the associated axis
**    numbers, dimensions and element strides within the larger box.
**    The addressing strides are also found for matrices and vectors.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED:  wdj@lithos.c3.lanl.gov  Thu Mar  4 13:57:02 MST 1993
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**    See description in "sagrd.fm4" for more details.
**
***********************************************************************
*
      implicit none
*
      integer iaxin1, iaxin2
      integer istrd1, istrd2
      integer nin1, nin2
      integer ivstrr, ivstr1, ivstr2
      integer imstrr, imstrc, imstr1, imstr2
      integer ia(*)
      integer iparm(*)
      integer ineltb(*)
      integer inelts(*)
*
      integer nv
      integer ndim
      integer nsten
      integer nb
      integer ns
      integer imaxgr
      external imaxgr
      integer ivaxgr
      external ivaxgr
      integer iaxis
      integer iprdax
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:57 1994 $
*     $Id: xplane.fm4,v 1.9 1994/07/20 18:20:36 joubert Exp $
*     $Revision: 1.9 $
************************************************************************
*
      nv = iparm(3 )
      ndim = ia (1 )
      nsten = ia (2)
      nb = ia (3 )
      ns = nv / nb
      iprdax = 1
      iaxin1 = 0
      iaxin2 = 0
      do 8511 iaxis = 1, ndim
        if (iaxin2.eq.0 .and. iaxin1.ne.0 .and. inelts(iaxis).gt.1) then
          iaxin2 = iaxis
          istrd2 = iprdax
        endif
        if (iaxin1.eq.0 .and. inelts(iaxis).gt.1) then
          iaxin1 = iaxis
          istrd1 = iprdax
        endif
        iprdax = iprdax * ineltb(iaxis)
 8511 continue
*
      if (iaxin1 .eq. 0) then
        iaxin1 = 1
        iaxin2 = 1
        istrd1 = 1
        istrd2 = 1
        nin1 = 1
        nin2 = 1
      else if (iaxin2 .eq. 0) then
        iaxin2 = iaxin1
        istrd2 = istrd1
        nin1 = inelts(iaxin1)
        nin2 = 1
      else
        nin1 = inelts(iaxin1)
        nin2 = inelts(iaxin2)
      endif
*
*     if(nb > 1)then
        ivstrr = ivaxgr(2 ,1 ,ia(5),nb,ns,nsten) - ivaxgr(1 ,1 ,ia(5),
     &     nb,ns,nsten)
        imstrc = imaxgr(1 ,2 ,1,1 ,ia(4),nb,ns,nsten) - imaxgr(1 ,1 ,1,
     &     1 ,ia(4),nb,ns,nsten)
        imstrr = imaxgr(2 ,1 ,1,1 ,ia(4),nb,ns,nsten) - imaxgr(1 ,1 ,1,
     &     1 ,ia(4),nb,ns,nsten)
*     else
*       ivstrr = 1
*       imstrc = 1
*       imstrr = 1
*     endif
*
      ivstr1 = ivaxgr(1 ,1+istrd1,ia(5),nb,ns,nsten) - ivaxgr(1 ,1 ,ia(
     &   5),nb,ns,nsten)
      ivstr2 = ivaxgr(1 ,1+istrd2,ia(5),nb,ns,nsten) - ivaxgr(1 ,1 ,ia(
     &   5),nb,ns,nsten)
      imstr1 = imaxgr(1 ,1 ,1,1+istrd1,ia(4),nb,ns,nsten) - imaxgr(1 ,1 
     &   ,1,1 ,ia(4),nb,ns,nsten)
      imstr2 = imaxgr(1 ,1 ,1,1+istrd2,ia(4),nb,ns,nsten) - imaxgr(1 ,1 
     &   ,1,1 ,ia(4),nb,ns,nsten)
*
      return
      end
