************************************************************************
**  ^ROUTINE: ximal - routine to allocate integer memory. (^)
**
      subroutine ximal ( iptr, nwords, iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    This routine is the general purpose integer memory allocator.
**    it calls either the Fortran or the **    error checking.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lanl.gov
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    BASICAL - (^)
      integer ier
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
      integer iptr
      integer nwords
*
         integer memtmp
         integer mtmp2
      integer fused
      integer imem
*     external imem
      integer smem
*     external smem
      integer iequiv
      real requiv
      equivalence (iequiv,requiv)
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:57 1996 $
*     $Id: ximal.fm4,v 1.1 1994/04/21 01:37:34 joubert Exp $
************************************************************************
*
      iptr = (iparm(6))
      if (nwords .le. 0) go to 900
*
         if (iparm(6) .eq. 1) then
           call ximalloc (iwk,nwords,iptr)
           iwk(1) = iwk(1) + (nwords) + 2
           iparm(9) = max(iparm(9),iwk(1))
         else
           iptr = imem(iwk,nwords)
           iwk(1) = iwk(1) + (nwords) + 2
           iparm(9) = max(iparm(9),iwk(1))
*
         endif
         memtmp = 1 - min(1,iabs(iptr-(iparm(6))))
         call xgladd (1,memtmp,mtmp2, iparm , fparm , iwk , fwk , ier )
         if (memtmp .ne. 0) then
                ier = -2
                call xersho ( ier, 'ximal' , iparm , 900 )
                go to 900
         endif
*
  900 continue
*
      return
      end
