************************************************************************
**  ^ROUTINE: xgladd - Global elementwise addition of integer vectors.
**                       (^)
**
      subroutine xgladd ( nelts, ivec, ivwork, iparm , fparm , iwk , 
     &   fwk , ier )
**
**  ^DESCRIPTION:
**
**    This routine computes the elementwise global sum of integer
**    elements in the vector ivec.
**    For 1\leq i\leq nelts, ivec(i) is globally added across
**    processors.
**    ivwork is a work vector of the same dimension as ivec.
**    This is a global operation and therefore must be executed on
**    all nodes before execution may continue.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:58 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS: vwork is a work array
**
**  ^ALGORITHM:
**    Chosen from the following:
**      - Bidirectional exchange
**      - Send all to node zero, operate, broadcast
**      - System subroutine call
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
*#    BASICAL - (^)
*
       integer ivwork(*)
       integer ivec(*)
      integer nelts
*
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
*
      integer i
*
*
      integer ineqv
      external ineqv
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:58 1996 $
*     $Id: xgladd.fm4,v 1.6 1994/04/30 04:39:15 joubert Exp $
*     $Revision: 1.6 $
*     $Log: xgladd.fm4,v $
*     Revision 1.6  1994/04/30  04:39:15  joubert
*     improved error handling
*
*     Revision 1.5  1994/03/27  10:28:38  ak
*     Added code for Express on RS6000
*
*     Revision 1.4  1994/02/18  08:49:16  joubert
*     mpi, t3dpvm versions completed; misc other changes
*
*     Revision 1.3  1994/02/04  03:00:15  joubert
*          .
*
*     Revision 1.3  94/02/01  09:53:12  wdj
*
*
*     Revision 1.2  1993/12/09  04:07:58  joubert
*     debugged Paragon version
*
*     Revision 1.1  1993/12/04  09:06:54  joubert
*     mainly mods to iPSC/Paragon
*
*     Revision 1.0  1993/08/24  09:42:09  joubert
*
************************************************************************
*
      if (nelts .le. 0) return
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
*
          call gisum (ivec,nelts,ivwork)
*
  900 continue
*
      return
      end
