************************************************************************
**  ^ROUTINE: xerstr - routine to print out the header, mesage or tail
**                     of the error message. (^)
**
       subroutine xerstr ( icall, pstr, iparm, ier )
**
**  ^DESCRIPTION:
**    This routine prints out error message information at a lower
**    level than xersho.  Based on icall, it either prints out the
**    header part of the message, the text lines of the message,
**    or the tail part of the message.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 11:59:59 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS: none
**
**  ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
      integer icall
      integer ier
      character*(*) pstr
      integer iparm(*)
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 11:59:59 1996 $
*     $Id: xerstr.fm4,v 1.8 1994/04/30 04:40:17 joubert Exp $
*     $Revision: 1.8 $
************************************************************************
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if ( icall .eq. -1) then
        if (ipme .eq. 0) then
          write (iparm(1),1010)
        endif
      else if ( icall .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),1011)
        endif
      else if (iabs(icall) .eq. 2) then
        if (ipme .eq. 0) then
          write (iparm(1),1020) pstr
        endif
      else if (iabs(icall) .eq. 3) then
        if (ipme .eq. 0) then
          write (iparm(1),1030) pstr
        endif
      else if (iabs(icall) .eq. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),1040)
        endif
      endif
  900 continue
      return
*-------------------------format statements-----------------------------
 1010 format (//1x,60('*') / 1x,18('*'),' F a t a l    E r r o r ',18('*
     &') / 1x,60('*') /)
 1011 format (//1x,60('*') / 1x,22('*'), ' W a r n i n g ', 23('*') / 
     &   1x,60('*') /)
 1020 format (1x,'Routine ',a)
 1030 format (1x,a)
 1040 format (/1x,60('*')/)
      end
