************************************************************************
**  ^ROUTINE: xeloc  -  Auxiliary routine for Householder reflections.
**                     (^)
**
      subroutine xeloc (ploc,eloc,nploc,offend, iparm , fparm , iwk , 
     &   fwk , ier )
**
**  ^DESCRIPTION:
**    Routine to take a (ploc,eloc) pair for a global vector element number
**    and "normalize" it so that eloc is between 1 and iparm(3) for
**    ipme=ploc.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHRDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
      integer ploc
      integer eloc
      integer nploc
      integer offend
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer i
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:00 1996 $
*     $Id: xeloc.fm4,v 1.1 1995/01/16 17:47:19 mclay Exp $
*     $Revision: 1.1 $
*     $Log: xeloc.fm4,v $
*     Revision 1.1  1995/01/16  17:47:19  mclay
*     Helper routine for householder.
*
************************************************************************
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      offend = 0
*
   81   continue
        if (ploc .gt. nproc-1) then
          offend = 1
          go to 900
        endif
        if (eloc .le. nploc) go to 82
        ploc = ploc + 1
        eloc = 1
        nploc = 0
        if (ploc .eq. ipme) nploc = iparm(3)
        call xgladd (1,nploc,i, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        go to 81
   82   continue
*
  900 continue
*
      return
      end
*-----------------------------------------------------------------------
