************************************************************************
**  ^ROUTINE: WWCDOT - Routine to take dot products.  Can be called as
**                       wcdot, wrdot, or wdot.  The first, wcdot, takes
**                       the actual or pseudo dot product based on the
**                       passed variable idot.  The second, wrdot,
**                       computes the real part of the dot product.  The
**                       third, wdot, calculates the actual dot product
**                       only.
**
      subroutine swcdot ( c , y , x , idot , iparm , fparm , iwk , fwk ,
     &    ier )
**
**  ^DESCRIPTION:
**   wcdot - Compute either the true dot product (c =y^{*} x), or a pseudo
**    dot product (c =y^{T} x) which uses the transpose rather than the
**    conjugate transpose of the left vector. The subroutine argument idot
**    is used to toggle between taking the actual (idot = 1) and pseudo
**    (idot = 0) dot product.  In the calling program idot is normally set
**    in the iparm varialbe iparm(IDOT).
**
**   wdot - Ccompute the true dot product (c =y^{*} x).
**
**   wrdot - Compute the real part of the (actual) dot product
**    (c = y^{*} x) of two vectors.
**
**    These three routines are part of the Low-level level-1 BLAS-type
**    routine required by pcg package.  Written for Sun, Cray YMP, and
**    generic f77; as set by m4 variable MACHINE.  On a Cray YMP the
**    vector is partitioned out to all available processors.  The
**    partitioning is done using compiler directives, thus the complier
**    decides how the partitioning is done.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:00:09 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS: During complex computations when calculation of only the
**    real part of the dot product is requested, the global add need only be
**    done on the real part of c, however, it is now done on both the real and
**    imaginary parts, requiring extra communications work.
**
**  ^ALGORITHM:
**    Euclidean inner product
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    BASICAL             (^)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
           real y(*)
           real x(*)
          real c
          integer idot
*
          real sum
      integer nv
      integer i
*
          real sdot
          external sdot
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:09 1996 $
*     $Id: dot_template.m4,v 1.6 1994/07/15 19:43:42 joubert Exp $
*     $Revision: 1.6 $
*     $Log: dot_template.m4,v $
*#    Revision 1.6  1994/07/15  19:43:42  joubert
*#    matvec mods
*#
*#    Revision 1.5  1994/06/13  22:09:45  joubert
*#    added Householder GMRES iterative method
*#
*#    Revision 1.4  1994/05/07  11:01:32  joubert
*#    implemented pvmRS6k version
*#
*#    Revision 1.2  1993/12/09  04:07:42  joubert
*#    debugged Paragon version
*#
*#    Revision 1.1  1993/11/17  20:22:59  aal
*#    Merged wcdot.fm4, wrdot.fm4 and wdot.fm4 into dot_template.m4.
*#    dot_template.m4 is a macro file used by wcdot.fm4, wrdot.fm4, and
*#    wdot.fm4.  It expands to become the body of these routines.
*#
*     Revision 1.4  1993/05/19  07:22:59  joubert
*     cosmetic changes; fixed Ncube and cmmd versions
*
*     Revision 1.3  1993/05/12  03:00:48  joubert
*     Added reverse communication interface
*
*     Revision 1.2  1993/04/30  23:21:35  joubert
*     cosmetic changes / iparm name changes / set-io-mode improvements
*
*     Revision 1.1  1993/04/30  03:03:16  mclay
*
************************************************************************
*
      nv = iparm(3)
*
                sum = sdot (nv,y,1,x,1)
*
                call gssum(sum,1*(1),c)
              c = sum
*
          fparm(3) = fparm(3) + (2.*nv)
*
*
  900 continue
      return
      end
