************************************************************************
**  ^ROUTINE: WJAGR - Preconditioner linking routine,
**                     ja preconditioner, gr format.(^)
**
      subroutine sjagr ( ijob , accel , ia , ja , a , u , uexact , b , 
     &   iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine links in the package routines necessary for the ja
**    preconditioner, gr format, and then passes things down to
**    the routine "prec".
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:00:29 1996 $
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:
**       WPREC  - routine to actually call preconditioner generator and itmeth
**       WCKJA  - routine to check correctness of the format
**       WSCJA  - scaling routine
**       WMVJA  - matvec routine
**       WJAJAX - preconditioner routine
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    PRECAL            - preconditioner routine arg list
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      external accel
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
       integer ia(*)
       integer ja(*)
       real a(*)
       real u(*)
       real uexact(*)
       real b(*)
      external sprec
      external sckgr
      external sscgr
      external smvgr
      external sjagrx
      call sprec ( sckgr, sscgr, sscgr, smvgr, sjagrx, ijob , accel , 
     &   ia , ja , a , u , uexact , b , iwk , fwk , iparm , fparm , ier 
     &   )
      return
      end
******^^****************************************************************
************************************************************************
