************************************************************************
** ^ROUTINE: WIFPPR - Routine to print i/fparm values. (^)
**
      subroutine sifppr ( ijob, iparm, fparm, ier )
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^DESCRIPTION:
**    Print out values of iparm and fparm at the beginning
**    or end of run, depending on iparm(level)
**
** ^AUTHOR:   wdj@beta.lanl.gov
**
** ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:00:31 1996 $
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: none
**
** ^SIDE_EFFECTS: none
**
** ^DOCUMENTATION:
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
      integer ijob
      integer ier
      integer iparm(*)
      real fparm(*)
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer icallr
      integer i
      character*6 inames(50), fnames(30)
      data inames(1) / 'nout  ' /
      data inames(2) / 'levout' /
      data inames(3) / 'nru   ' /
      data inames(4) / 'itsmax' /
      data inames(5) / 'its   ' /
      data inames(6) / 'malloc' /
      data inames(7) / 'nwi   ' /
      data inames(8) / 'nwf   ' /
      data inames(9) / 'nwiusd' /
      data inames(10) / 'nwfusd' /
      data inames(11) / 'iptr  ' /
      data inames(12) / 'ntest ' /
      data inames(13) / 'iqside' /
      data inames(14) / 'iuinit' /
      data inames(15) / 'needrc' /
      data inames(16) / 'ns1   ' /
      data inames(17) / 'ns2   ' /
      data inames(18) / 'ickstg' /
      data inames(19) / 'iuexac' /
      data inames(20) / 'idot  ' /
      data inames(21) / 'istats' /
      data inames(22) / 'itimer' /
      data inames(23) / 'icomm ' /
      data inames(24) / 'msgmin' /
      data inames(25) / 'msgmax' /
      data inames(26) / 'msgtyp' /
      data inames(27) / 'iclev ' /
      data inames(41) / 'iscale' /
      data inames(42) / 'ictran' /
      data fnames(1) / 'ctimer' /
      data fnames(2) / 'rtimer' /
      data fnames(3) / 'flopsr' /
      data fnames(4) / 'zeta  ' /
      data fnames(5) / 'stptst' /
      data fnames(6) / 'alpha ' /
      data fnames(7) / 'relrsd' /
      data fnames(8) / 'relerr' /
      data fnames(11) / 'ctimei' /
      data fnames(12) / 'rtimei' /
      data fnames(13) / 'flopsi' /
      data fnames(21) / 'ctimet' /
      data fnames(22) / 'rtimet' /
      data fnames(23) / 'flopst' /
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:31 1996 $
*     $Id: ifppr.fm4,v 1.11 1994/04/30 04:39:42 joubert Exp $
*     $Revision: 1.11 $
************************************************************************
      if (ijob.ne.1 .and. ijob.ne.-1) return
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (iparm(2) .lt. 4) go to 900
      icallr = iparm(27)
      if (icallr .ge. 2) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ijob .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Initial top level parameters:'')')
        endif
        else
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Final top level parameters:'')')
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,a6,5x,i10)') (inames(i),iparm(i), i=41, 
     &       42)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,a6,8x,1pg20.10)') (fnames(i),fparm(i), i=
     &       21, 23)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
      endif
      if (icallr .ge. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ijob .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Initial iterative method level paramete
     &rs:'')')
        endif
        else
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Final iterative method level parameters
     &:'')')
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,a6,5x,i10)') (inames(i),iparm(i), i=31, 
     &       30)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,a6,8x,1pg20.10)') (fnames(i),fparm(i), i=
     &       11, 13)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
      endif
      if (icallr .ge. 0) then
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ijob .eq. 1) then
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Initial revcom level parameters:'')')
        endif
        else
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,''Final revcom level parameters:'')')
        endif
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,a6,5x,i10)') (inames(i),iparm(i), i=1, 
     &       27)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(5x,a6,8x,1pg20.10)') (fnames(i),fparm(i), i=
     &       1, 8)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
      endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
  900 continue
      return
      end
