************************************************************************
**  ^ROUTINE: WHOUSE - Routine to calculate Householder vector.
**                     (^)
**
      subroutine shouse (ix,ixind,ploc,eloc,iv,ivind,xmult, iparm , 
     &   fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    A Householder reflection vector (iv,ivind) is calculated based
**    on (ix,ixind).  The reflection transforms the vector to have
**    zeros except for the vector entry indicated by (ploc,eloc).
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**    Gene Golub an Charles Van Loan, Matrix Computations, 2nd ed.,
**    Johns Hopkins Press, 1989, p. 196.
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ier
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
      integer ix
      integer ixind
      integer ploc
      integer eloc
      integer iv
      integer ivind
      real xmult
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      real xdot
      real xnorm
      real xentry
      real sgn
      real vdot
      real beta
      real vnorm
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:31 1996 $
*     $Id: house.fm4,v 1.1 1994/06/13 22:10:16 joubert Exp $
*     $Revision: 1.1 $
*     $Log: house.fm4,v $
*     Revision 1.1  1994/06/13  22:10:16  joubert
*     added Householder GMRES iterative method
*
************************************************************************
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
*
          call swrdot (xdot,fwk(ix+iparm(3)*(ixind)), fwk(ix+iparm(3)*(
     &       ixind)), iparm , fparm , iwk , fwk , ier )
      xnorm = sqrt(xdot)
*
      if (xnorm .eq. 0e0) then
        xentry = 0e0
        beta = 1e0
        xmult = 0e0
          call swfil (fwk(iv+iparm(3)*(ivind)),0e0, iparm , fparm , iwk 
     &       , fwk , ier )
      else
          call swgete (fwk(ix+iparm(3)*(ixind)),ploc,eloc,ploc,eloc,
     &       xentry, iparm , fparm , iwk , fwk , ier )
        if (xentry .eq. 0e0) then
          sgn = 1e0
        else
          sgn = +xentry/abs(xentry)
        endif
*       ---do it----------
        beta = xentry + sgn*xnorm
          call swscl ( fwk(iv+iparm(3)*(ivind)), fwk(ix+iparm(3)*(ixind)
     &       ), 1e0/beta, iparm , fparm , iwk , fwk , ier )
        xmult = -sgn*xnorm
      endif
*
          call swsete (fwk(iv+iparm(3)*(ivind)),ploc,eloc,ploc,eloc,1e0,
     &        iparm , fparm , iwk , fwk , ier )
*
*     ---get normsq of new vector v----------
      vdot = 1e0 + (xdot-(xentry)*xentry)/((beta)*beta)
      vnorm = sqrt(vdot)
      if (vnorm .ne. 0e0) then
          call swscl ( fwk(iv+iparm(3)*(ivind)), fwk(iv+iparm(3)*(ivind)
     &       ), 1e0/vnorm, iparm , fparm , iwk , fwk , ier )
      endif
*
  900 continue
*
      return
      end
*#-----------------------------------------------------------------------------
