************************************************************************
**  ^ROUTINE: WGMRH - gmrh iterative method, direct
**                        communication interface. (^)
**
      subroutine sgmrh ( ijob , suba , ia , ja , a , subq , iq , jq , q 
     &   , u , uexact , b , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    This routine interfaces the gmrh revcom routine via the wmeth interface
*     routine in order to apply the iterative method.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: wdj@lithos.c3.lanl.gov Thu May  6 13:12:38 MDT 1993
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    Preconditioned gmrh iterative method
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHAL           - accelerator arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external suba, subq
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
       integer ia(*)
       integer ja(*)
       integer iq(*)
       integer jq(*)
       real a(*)
       real q(*)
       real u(*)
       real uexact(*)
       real b(*)
*
      external smeth
      external sgmrhr
*
      call smeth ( sgmrhr , ijob , suba , ia , ja , a , subq , iq , jq ,
     &    q , u , uexact , b , iwk , fwk , iparm , fparm , ier )
*
      return
      end
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:34 1996 $
*     $Id: gmrh.fm4,v 1.1 1994/06/13 22:10:13 joubert Exp $
*     $Revision: 1.1 $
************************************************************************
