



/*---Only need this routine for some machines---*/


#define NULL 0
   typedef struct CM_complex_float
                             {float  realpart, imagpart;} CM_complex_float_t;
  typedef struct CM_complex {double realpart, imagpart;} CM_complex_t;

#define NULL 0
       
            
          
         
       


/************************************************************************
** ^ROUTINE: sfmalloc_ - Fortran-callable routine to allocate floating point
**                      memory. (^)
*/

void sfmalloc_ ( arr , nelts , iofst )

/*
** ^DESCRIPTION:
**    This routine allocates floating point memory of working precision
**    and arithmetic.  The Fortran caller passes in the base array he will
**    use to access this memory, and the number of words requested.
**    This routine does the allocation and returns the (equivalent)
**    first element of the base array of the allocated memory.
**    This all works of course only if one has a linear sequential
**    address space on his machine, which is usually true.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED:  wdj@lithos.c3.lanl.gov  Thu Mar  4 13:57:02 MST 1993 $
**
** ^REQUIREMENTS:
**    Subroutines:
**       malloc - standard **
** ^ARGUMENTS: see below.
**
** ^SIDE_EFFECTS: allocates system memory which should be freed after use.
**
** ^DOCUMENTATION:
**
** ^MACROS:
*#    CHEAD             - C file header for every C file 
*#                        (^./src/m4defs/defs_general.m4)
*#    CINCLUDES         - system includes for C
*#                        (^./src/m4defs/defs_general.m4)
*#    CTYPE             - general f.p. type in c 
*#                        (^./src/m4defs/defs_general.m4)
*#    EVAL              - the builtin m4 evaluation macro
*#                        (^./src/m4defs/defs_redefine.m4)
*#    F77               - YES for generic f77 version
*#                        (^./src/m4defs/defs_switches.m4)
*#    IFELSE            - the builtin m4 if else macro
*#                        (^./src/m4defs/defs_redefine.m4)
*#    NO                - define NO as 0
*#                        (^./src/m4defs/defs.m4)
*#    WFNAMEINC(name)    - Creates a macro called W`NAME' which expands to
*#                        a fortran callable `c' routine.
*#                        (^./src/m4defs/defs_general.m4)
**
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Mon Mar  1 17:41:51 1993 $
*     $Id: fmalloc.cm4,v 1.11 1995/01/16 17:31:35 mclay Exp $
*     $Revision: 1.11 $
************************************************************************/

/*----------------------------------------------------------------------

  Notes
  -----
  - a failure to allocate will be denoted by iofst=0.  Then when we
    get back to the caller, we add 1, giving null pointer of 1, the
    appropriate null pointer code for 6=1.
  - note that even though ptr is adequately aligned, arr may not be.
    Our means of solving this problem are as follows: we allocate two extra
    words; Then compute whether the offset from the base array to the
    allocation is an even multiple of FWORD.  If it is then skip 1 FWORD
    forward.  If it is not then skip until it is an even multiple.
    Use one int word back from the start of the user space to store the
    amount of skip used.

----------------------------------------------------------------------*/

/***Subroutine Arguments***/
  float *arr;           /* base array to reference new memory */
                        /* (must be of type CTYPE, else alignment may be
                           messed up) */
  int   *nelts,         /* number of elements requested */
        *iofst;         /* (output) offset within arr where the new memory
                           begins */

/***Begin Program Block***/
{
  int *iptr;             /* used to store the delta */
  float *ptr;            /* temp pointer */
  long flofst;           /* pointer difference, in floats */
  long flofst_up;        /* Guaranteed to be a multiple FWORD offset. */
  int delta;             /* = flofst_up - flofst */

  /*---make the allocation---*/
  ptr = (float *) malloc ( ((*nelts)+2)*sizeof(float) );

  /*---calculate offset in arr---*/
  if (((int)ptr) == 0)  /*---null pointer---*/
   {
     (*iofst) = 0;
     return;
   }

  /*---get location of new ptr relative to arr, in floats---*/
  flofst = (int) (ptr-arr);

  /*---round up to next multiple of fwords---*/
  if (flofst >= 0)
    flofst_up = ( ((flofst % 1) == 0) ?
	         flofst + 1:
	         ((flofst + 1 - 1)/1)*1);

  else
    flofst_up = ( ((flofst % 1) == 0) ?
	         flofst + 1:
	         ((flofst - 1 + 1)/1)*1);


  /*---remember the delta location required---*/
  iptr = (int *) (arr + flofst_up);
  delta = (int) (flofst_up - flofst);
  *(iptr -1) = delta;

  /*---return offset adjusted for Fortran 1-based arrays---*/
  (*iofst) = flofst_up/1 + 1;
}



