************************************************************************
**  ^ROUTINE: WCKGR  - to check the validity of the user-supplied regular
**                     grid format.
**                     (^)
      subroutine sckgr ( u , uexact , b , ia , ja , a , iq , jq , q , 
     &   iparm , fparm , suba , subq , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**            Routine to check the validity of the user-supplied regular
**            grid format.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:00:39 1996 $
**
**  ^ARGUMENTS: See *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**   Common Blocks: none
**   Subroutines:
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    ALLAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  ALLAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba   - matvec routine
*#                        subq   - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier    - error return value.
*#                        iwffre - next free location in fwk
*#                        iwifre - next free location in iwk
*#                    !---Integer Arrays:
*#                        ia     - used to store indexing information for
*#                                 non-zero elements of matrix stored in a.
*#                        iparm  - used to pass integer parameters to and
*#                                 from the package.
*#                        iq     - used along with floating point array q
*#                                 and subroutine subq for preconditioning.
*#                        iwk    - integer workspace
*#                    !---Float Arrays:
*#                        a      - array used to store non-zero elements
*#                                 of the matrix A.
*#                        b      - right hand side of the linear system.
*#                        fparm  - used to pass floating point
*#                                 parameters to and from the package.
*#                        fwk    - floating work array space
*#                        q      - used along with integer array iq and
*#                                 subroutine subq for preconditioning
*#                        u      - solution vector. On input it contains
*#                                 the initial guess.
*#                        ubar   - exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      external suba , subq
      integer ier
       integer iwk(*)
       integer iparm(*)
       real fwk(*)
       real fparm(*)
       integer ia(*)
       integer ja(*)
       integer iq(*)
       integer jq(*)
       real a(*)
       real q(*)
       real u(*)
       real uexact(*)
       real b(*)
*
      integer nv
      integer ndim
      integer nsten
      integer nb
      integer ns
      integer imaxgr
      external imaxgr
      integer ivaxgr
      external ivaxgr
      integer iaxis
      integer isten
      integer nsbgrd
      integer nsgax
*
          integer npax
          integer nmap
          integer nprc
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
*
         integer ilog2
         external ilog2
*
******^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:39 1996 $
*     $Id: ckgr.fm4,v 1.14 1994/07/20 18:19:21 joubert Exp $
*     $Revision: 1.14 $
************************************************************************
*
      if (ia(1) .lt. 1 .or. ia(1) .gt. 32) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Invalid NDIM param
     &eter in IA' )
                go to 900
      endif
      if (ia(2) .lt. 1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Invalid NSTEN para
     &meter in IA' )
                go to 900
      endif
      if (ia(3) .lt. 1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Invalid NB paramet
     &er in IA' )
                go to 900
      endif
      if (ia(4) .lt. -1 .or. ia(4) .gt. 24-1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Invalid MAXORD par
     &ameter in IA' )
                go to 900
      endif
      if (ia(5) .lt. -1 .or. ia(5) .gt. 2-1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Invalid VAXORD par
     &ameter in IA' )
                go to 900
      endif
*
      ndim = ia(1)
      nsten = ia(2)
      nb = ia(3)
*
      nsbgrd = 1
      do 8511 iaxis = 1, ndim
        nsgax = ja(iaxis+ndim*nsten)
        if (nsgax .lt. 1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Grid dimension les
     &s than 1' )
                go to 900
        endif
        nsbgrd = nsbgrd * nsgax
 8511 continue
*
      iparm(3) = nb*nsbgrd
*
          nprc = 1
          do 8513 iaxis = 1, ndim
            npax = ja(iaxis+ndim*(nsten+1))
            if (npax .lt. 1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Number of processo
     &rs on an axis less than 1' )
                go to 900
            endif
            nmap = ja(iaxis+ndim*(nsten+2))
            if (nmap.ne.0 .and. nmap.ne.1) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Improper axis mapp
     &ing' )
                go to 900
            endif
**#             if (2**(ilog2(npax)) .ne. npax) then
**#               HANDLE_ERROR(ERRMAT,
**#                      'Number of processors on an axis must be power of 2')
**#             endif
            nprc = nprc * npax
 8513     continue
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
          if (nprc .ne. nproc) then
                ier = -11
                call xersho ( ier, 'sckgr' , iparm , 'Inconsistency in n
     &umber of processors requested' )
                go to 900
          endif
*
      if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Regular Grid Matrix Format.'
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     NDIM = ', ndim, '   NSTEN = ', nsten,
     &        '   NB = ', nb
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Stencil Definition:'
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        do 8515 isten = 1, nsten
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Stencil Point No. ', isten, ': Offset
     &s: ', (ja(iaxis+ndim*(isten-1)),iaxis=1,ndim)
        endif
 8515   continue
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Subgrid Dimensions:                ',
     &        (ja(iaxis+ndim*nsten),iaxis=1,ndim)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Processor-grid Dimensions:         ',
     &        (ja(iaxis+ndim*(nsten+1)),iaxis=1,ndim)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Processor-grid Axis Embeddings:    ',
     &        (ja(iaxis+ndim*(nsten+2)),iaxis=1,ndim)
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
      endif
*
  900 continue
      return
      end
