************************************************************************
** ^ROUTINE: ivaxgr - Compute indexing polynomial for vector,
**                    Regular Grid format.
**                       (^)
      integer function ivaxgr (ibr,is,vaxord,nb,ns,nsten)
**
** ^DESCRIPTION:
**    Computes (1-based) indexing polynomial for matrix in regular
**    grid stencil format.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED:  wdj@lithos.c3.lanl.gov  Thu Mar  4 13:57:02 MST 1993
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Subroutines: See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^ALGORITHM:
**
** ^REFERENCES:
**
** ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ibr
      integer is
      integer vaxord
      integer nb, ns, nsten
*
      integer vaxeff
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov
*     $Id: ivaxgr.fm4,v 1.3 1994/10/26 19:22:37 joubert Exp $
*     $Revision: 1.3 $
************************************************************************
*
      vaxeff = vaxord
         if (vaxeff .eq. -1) vaxeff = 1
*
      go to (101,102) 1+vaxeff
*
  101 continue
      ivaxgr = ibr + nb*(is -1)
      return
*
  102 continue
      ivaxgr = is + ns*(ibr-1)
      return
*
      end
