************************************************************************
** ^ROUTINE: islice - integer function to map from an element number
**                    in the slice to an element number in the whole
**                    subgrid. (^)
**
      integer function islice (ielt,ndim,nsg,nsl,ilb)
**
** ^DESCRIPTION:
**    For each stencil point in a finite difference operator operating
**    over a rectangular subgrid, a perturbed grid is obtained that is
**    spread over upto 2**ndim subgrids (ndim is the number of dimensions
**    in the problem, = 2 for a 2D problem, etc.) The portions of this
**    perturbed subgrid that lie in each of the 2**ndim subgrids are
**    referred to here as slices. Given the integer ielt, which corresponds
**    to the location of a gridpoint in the slice by local natural ordering
**    within the slice, it returns an integer which corresponds to the
**    location of the same gridpoint according to natural ordering in the
**    entire subgrid.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:58 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: none
**    The subroutine xslice must be accessed before this slice to
**    determine data such as slice dimensions as well as location
**    with respect to the subgrid.
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**    See description in "sagrd.fm4" for a more detailed description.
**
************************************************************************
      implicit none
      integer ielt
      integer ndim
      integer nsg(*)
      integer nsl(*)
      integer ilb(*)
      integer i
      integer itmp
      integer inat
      integer imi(32)
      integer imodf
      external imodf
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:58 1994 $
*     $Id: islice.fm4,v 1.7 1994/07/20 18:20:26 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
      itmp = ielt
      do 8511 i = 1, ndim
        imi(i) = imodf(itmp,nsl(i))
        itmp = (itmp-imi(i))/nsl(i)
 8511 continue
       do 8513 i = 1, ndim
      imi(i) = imi(i) + ilb(i)
 8513 continue
      inat = imi(ndim)
      do 8515 i = ndim-1, 1, -1
        inat = inat*nsg(i) + imi(i)
 8515 continue
      islice = inat
      return
      end
