************************************************************************
**  ^ROUTINE: iproc - map from subgrid number to processor number. (^)
**
      integer function iproc (igrid,ndim,npax)
**
**  ^DESCRIPTION:
**
**    Maps from (natural ordering) subgrid number to machine processor
**    number.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:59 1994 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED: see below.
**
************************************************************************
      implicit none
      integer igrid
      integer ndim
      integer npax(*)
      integer iprdax
      integer itmp
      integer nprcax
      integer iprcax
      integer iaxis
      integer imodf
      external imodf
      integer igray
      external igray
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:59 1994 $
*     $Id: iproc.fm4,v 1.6 1994/02/04 03:03:01 joubert Exp $
*     $Revision: 1.6 $
************************************************************************
      iproc = 0
      itmp = igrid
      iprdax = 1
      do 8511 iaxis = 1, ndim
        nprcax = npax(iaxis)
        iprcax = imodf(itmp,nprcax)
        if (npax(ndim+iaxis) .eq. 1) then
          iproc = iproc + iprdax*igray(iprcax)
        else
          iproc = iproc + iprdax*(iprcax)
        endif
        itmp = (itmp-iprcax)/nprcax
        iprdax = iprdax*nprcax
 8511 continue
      return
      end
