************************************************************************
** ^ROUTINE:  ineqv - integer neqv (exclusive or) function.
**                    (^)
      integer function ineqv (m,n)
**
** ^DESCRIPTION:
**    Returns the exclusive or of two nonnegative integers.
**
** ^AUTHOR:   wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:14:28 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
** ^SIDE_EFFECTS:
**
************************************************************************
      implicit none
      integer m
      integer n
      integer mtemp, mtemp2
      integer ntemp, ntemp2
      integer nret
      integer ipow
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:14:28 1994 $
*     $Id: ineqv.fm4,v 1.5 1994/02/04 02:59:55 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
      mtemp = m
      ntemp = n
      nret = 0
      ipow = 1
   10 continue
        if (mtemp.eq.0 .and. ntemp.eq.0) go to 20
        mtemp2 = mod(mtemp,2)
        ntemp2 = mod(ntemp,2)
             if (mtemp2.eq.0 .and. ntemp2.eq.1) then
          nret = nret + ipow
        else if (mtemp2.eq.1 .and. ntemp2.eq.0) then
          nret = nret + ipow
        endif
        mtemp = mtemp/2
        ntemp = ntemp/2
        ipow = ipow *2
        go to 10
   20 continue
      ineqv = nret
      return
      end
