************************************************************************
**  ^ROUTINE: imstrt - Initialization  routine for the 0 malloc routine (^)
**
**
      subroutine imstrt(iwk,size,ier)
**  ^DESCRIPTION:  This routine initializes the array so it can be used
**      by the allocation routine.  The array is setup as follows:
**         iwk(3)      = rover      ! The first Void (rover)
**         iwk(4) = 4 ! the array has been initialized
**         iwk(5)     = nvoids     ! The number of nvoids
**         iwk(6)  = nuser      ! number of user blocks (initially 0)
**         iwk(7)      = size       ! size of the array.
**
**         iwk(9-1)   = -1         ! Barrier
**         iwk(9)     = voidsize   ! size of block
**         iwk(size-1)     = voidsize   ! size of block
**         iwk(size)       = -1         ! Barrier
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Mon Jul 19 21:21:10 1993
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:53:12 1994 $
**
**  ^REQUIREMENTS:  That the size is correct.
**
**
**  ^SIDE_EFFECTS:  The locations of iwk are changed as shown above.
**
**  ^ALGORITHM:     The array is a "next fit" allocation scheme
**
**  ^MACROS_USED:
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    ISTART - (^)
*#    NSIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
**
****^^******************************************************************
*
      implicit none
*
      integer size
       integer iwk(*)
      integer ier
*
      integer nuser
      integer nvoids
      integer vdsize
      logical rtn
*
      logical imemck
      external imemck
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:53:12 1994 $
*     $Id: imstrt.fm4,v 1.7 1994/05/10 01:20:37 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
*
      vdsize = size - 9
      nvoids = 1
      nuser = 0
      if (size .lt. 13) then
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['iwk too small'])
      endif
**#   if (iwk(INITIALIZE) == INITIALIZE) then
**#     ier = ERRMEM
**#     go to CLEANUP_LABEL
**#     HANDLE_ERROR(ERRMEM,['Re-initializing memory'])
**#   endif
      iwk(3) = 9
      iwk(4) = 4
      iwk(5) = nvoids
      iwk(6) = nuser
      iwk(7) = size
*
      iwk(9-1) = -1
      iwk(9) = vdsize
      iwk(9+1) = 9
      iwk(9+2) = 9
      iwk(size-1) = vdsize
      iwk(size) = -1
      iwk(1) = 9
      iwk(2) = 9
*
      rtn = imemck(iwk)
      if (.not.rtn) then
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Re-initializing memory'])
      endif
*
  900 continue
      return
      end
