************************************************************************
** ^ROUTINE:  imodf - (integer function) Modulus function which handles
**                    negative integers. (^)
**
      integer function imodf ( i, n )
**
** ^DESCRIPTION:
**    Modulus, "as it was intended to be".  That is, the floor function
**    rather than the truncation function is used, so that the mod of
**    negative numbers turns out right, and mod is truly periodic. For
**    example,
**
**         i   n   mod(i,n)   imodf(i,n)
**        -5   3      -2          1
**        -4   3      -1          2
**        -3   3       0          0
**        -2   3      -2          1
**        -1   3      -1          2
**         0   3       0          0
**         1   3       1          1
**         2   3       2          2
**         3   3       0          0
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:55 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**    The second argument "n" must be positive.
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**
**********************************************************************
      implicit none
      integer i
      integer n
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:55 1994 $
*     $Id: imodf.fm4,v 1.5 1994/02/04 03:02:59 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
      if (i .ge. 0) then
        imodf = mod(i,n)
      else
        imodf = i + ((-i-1)/n+1)*n
      endif
      return
      end
