************************************************************************
** ^ROUTINE: imi2i - integer function to map a multiindex to a
**                   regular index, according to a given base. (^)
**
      integer function imi2i (imi,ndim,nsg)
**
** ^DESCRIPTION:
**    Converts an index with bases represented in nsg of dimension ndim
**    to a corresponding multiindex.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:56 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**
****^^******************************************************************
      implicit none
      integer ndim
      integer imi(*)
      integer nsg(*)
      integer i
      integer inat
****^^**********************************************(*******************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:56 1994 $
*     $Id: imi2i.fm4,v 1.5 1994/02/04 03:02:57 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
      inat = imi(ndim)
      do 8511 i = ndim-1, 1, -1
        inat = inat*nsg(i) + imi(i)
 8511 continue
      imi2i = inat
      return
      end
