************************************************************************
**  ^ROUTINE: imfree - This returns memory and places it in void list. (^)
**
**
      subroutine imfree(iwk,aloc,ier)
**  ^DESCRIPTION:
**       This routine puts memory back on free list.  It attempts to join
**     voids if they are next to it.
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Tue Jul 20 12:38:55 1993
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 15:50:23 1994 $
**
**  ^REQUIREMENTS:
**       must have been allocated from this array.
**
**  ^SIDE_EFFECTS:
**       changes void list
**
**  ^ALGORITHM:
**
**  ^MACROS_USED:
*#    ERRMEM - (^)
*#    HANDLE_ERROR - (^)
*#    IGETSIZ - (^)
*#    IGETVSIZ - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    VOID_BACKWARD - (^)
*#    VOID_FORWARD - (^)
**
****^^******************************************************************
*
      implicit none
*
       integer iwk(*)
      integer aloc
      integer ier
*
      integer forwrd,bckwrd
      integer go
      integer left,right
      integer loc
      integer nvoids
      integer rover
      integer size
      integer vdsize
      logical rtn
*
      logical imemck
      external imemck
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 15:50:23 1994 $
*     $Id: imfree.fm4,v 1.6 1994/04/30 04:39:48 joubert Exp $
*     $Revision: 1.6 $
************************************************************************
*
      if (iwk(4) .ne. 4) then
        aloc = -1
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['error array not initialized'])
      endif
*
      rover = iwk(3)
      nvoids = iwk(5)
*
      loc = aloc - 1
      size = abs(iwk(loc))
      if (iwk(loc) .ne. iwk(loc+size-1)) then
        aloc = -1
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Boundary words not the same'])
      endif
*
*
      if (nvoids .eq. 0) then
        nvoids = 1
        rover = loc
        go = rover
        iwk(rover) = size
        iwk(rover+1) = rover
        iwk(rover+2) = rover
        iwk(rover + size - 1) = iwk(rover)
      else
*
        go = rover
*
        if (iwk(loc-1) .gt. 0) then
*
          vdsize = iwk(loc-1)
          left = loc - vdsize
          vdsize = vdsize + size
          iwk(left) = vdsize
          iwk(left+vdsize-1) = iwk(left)
*
          rover = left
        else
          if (loc .gt. rover) then
 8511       continue
              if ((iwk(rover+2) .lt. loc .or. iwk(rover+1) .eq. go) 
     &           .and. (loc .lt. rover)) go to 8513
              rover = iwk(rover+1)
            if (.not. (rover .eq. go)) go to 8511
 8513       continue
          endif
*
          left = iwk(rover+2)
*
          iwk(left+1) = loc
          iwk(rover+2) = loc
*
          iwk(loc) = size
          iwk(loc+1) = rover
          iwk(loc+2) = left
          iwk(loc+size-1) = iwk(loc)
          nvoids = nvoids + 1
          rover = loc
          vdsize = size
        endif
*
        right = rover + vdsize
        if (iwk(right) .gt. 0) then
          vdsize = iwk(right) + vdsize
          iwk(rover) = vdsize
          iwk(rover+vdsize-1) = iwk(rover)
*
          forwrd = iwk(right+1)
          bckwrd = iwk(right+2)
          iwk(forwrd+2) = bckwrd
          iwk(bckwrd+1) = forwrd
          nvoids = nvoids - 1
        endif
      endif
*
      iwk(3) = min(go,loc)
      iwk(5) = nvoids
      iwk(6) = iwk(6) - 1
      rtn = imemck(iwk)
      if (.not.rtn) then
        ier = -14
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Re-initializing memory'])
      endif
*
  900 continue
      return
      end
