************************************************************************
**  ^ROUTINE: imemck - This routine checks the status of the array
**                     allocation. (^)
**
**
      logical function imemck(iwk)
**  ^DESCRIPTION: This routine checks the status of the array by walking
**      down the array, checking to see if it is consistent.
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Tue Jul 20 16:05:33 1993
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:19:52 1994 $
**
**  ^REQUIREMENTS:  The array must be initialized first.
**
**
**  ^SIDE_EFFECTS: None
**
**  ^MACROS_USED:
*#    ERRMEM - (^)
*#    HANDLE_ERROR - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    ISTART - (^)
*#    NSIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    VOID_BACKWARD - (^)
*#    VOID_FORWARD - (^)
**
****^^******************************************************************
*
      implicit none
*
      integer iwk(*)
*
      integer bottom
      integer go
      integer ier, iparm
      integer ivoid
      integer maxsiz
      integer nuser
      integer nvoids
      integer size
      integer vdsize
      integer rover
      integer marker
*
      save marker
      data marker/122/
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:19:52 1994 $
*     $Id: imemck.fm4,v 1.7 1994/05/10 01:20:32 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
*
      imemck = .TRUE.
*
      if (iwk(4) .ne. 4) then
        imemck = .FALSE.
*      write (*,*) 'Error array not initialized'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'Error array not i
     &nitialized' )
                go to 900
      endif
*
      rover = iwk(3)
      nvoids = iwk(5)
*
      marker = marker + 1
*
      if (nvoids .gt. 0) then
*
        go = rover
        bottom = go
        do 8511 ivoid = 1,nvoids
*
          vdsize = iwk(rover)
*
          if (iwk(rover) .ne. iwk(rover+vdsize-1)) then
            imemck = .FALSE.
*      write (*,*) 'Void Boundaries Do Not Match'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'Void Boundaries D
     &o Not Match ' )
                go to 900
          endif
*
          iwk(rover+3) = marker
*
          if (iwk(iwk(rover+2)+1) .ne. rover) then
            imemck = .FALSE.
*      write (*,*) 'Void Linkage Bad'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'Void Linkage Bad'
     &              )
                go to 900
          endif
          if (iwk(iwk(rover+1)+2) .ne. rover) then
            imemck = .FALSE.
*      write (*,*) 'Void Linkage Bad'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'Void Linkage Bad'
     &              )
                go to 900
          endif
*
          bottom = min(bottom,rover)
*
          if (rover .gt. iwk(rover+1) .and. iwk(rover+1) .ne. go) then
            imemck = .FALSE.
*      write (*,*) 'void link list out of order'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'void link list ou
     &t of order' )
                go to 900
          endif
*
          rover = iwk(rover+1)
 8511   continue
      endif
*
      if (go .ne. rover) then
        imemck = .FALSE.
*      write (*,*) 'go does not equal rover'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'go does not equal
     & rover' )
                go to 900
      endif
*
      if (go .ne. bottom) then
        imemck = .FALSE.
*      write (*,*) 'go does not equal bottom of link list'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'go does not equal
     & bottom of link list' )
                go to 900
      endif
*
      rover = 9
      maxsiz = iwk(7)
      if (iwk(9-1) .ne. -1) then
        imemck = .FALSE.
*      write (*,*) 'iwk(9) does not equal -1'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , ' iwk(9) does not 
     &equal -1' )
                go to 900
      endif
      if (iwk(maxsiz) .ne. -1) then
        imemck = .FALSE.
*      write (*,*) 'iwk(maxsiz) does not equal -1'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , ' iwk(maxsiz) does
     & not equal -1' )
                go to 900
      endif
*
      nvoids = 0
      nuser = 0
 8513 if (rover .lt. maxsiz) then
        size = iwk(rover)
        if (abs(size) .lt. 3) then
          imemck = .FALSE.
*      write (*,*) 'size too small: size less than 3 '
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'size too small: s
     &ize less than 3 ' )
                go to 900
        endif
        if (size .lt. 0) then
*
          size = abs(size)
          nuser = nuser + 1
*
          if (iwk(rover) .ne. iwk(rover+size-1)) then
            imemck = .FALSE.
*      write (*,*) 'User Array Boundaries do not match'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'User Array Bounda
     &ries do not match' )
                go to 900
          endif
*
          rover = rover + size
        else
*
          nvoids = nvoids + 1
          vdsize = size
*
          if (iwk(rover) .ne. iwk(rover+vdsize-1)) then
            imemck = .FALSE.
*      write (*,*) 'Void Array Boundaries do not match'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'Void Array Bounda
     &ries do not match' )
                go to 900
          endif
*
          if (iwk(rover+3) .ne. marker) then
            imemck = .FALSE.
*      write (*,*) 'Did not mark this void'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'Did not mark this
     & void' )
                go to 900
          endif
*
          rover = rover + size
        endif
      go to 8513 
      endif
*
      if (rover .ne. maxsiz) then
        imemck = .FALSE.
*      write (*,*) 'rover does not equal maxsiz:'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'rover does not eq
     &ual maxsiz: ' )
                go to 900
      endif
*
      if (nuser .ne. iwk(6)) then
        imemck = .FALSE.
*      write (*,*) 'nuser: does not equal iwk(6)'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'nuser: does not e
     &qual iwk(6)' )
                go to 900
      endif
*
      if (nvoids .ne. iwk(5)) then
        imemck = .FALSE.
*      write (*,*) 'nvoids does not equal iwk(5):'
                ier = -14
                call xersho ( ier, 'imemck' , iparm , 'nvoids does not e
     &qual iwk(5): ' )
                go to 900
      endif
*
  900 continue
      return
 1000 format(1x,'void boundaries do not match:',/ ,'rover',i10,/ ,'vdsiz
     &e',i10,/ ,'iwk(rover)',i10,/ ,'iwk(rover+vdsize-1)',i10)
 1010 format(1x,'void linkage bad: ',/ ,'rover',i10,/ ,'iwk(rover+2)',
     &   i10,/ ,'iwk(iwk(rover+2)+1)',i10)
 1020 format(1x,'void linkage bad: ',/ ,'rover',i10,/ ,'iwk(rover+1)',
     &   i10,/ ,'iwk(iwk(rover+1)+2)',i10)
 1030 format(1x,'user boundaries do not match:',/ ,'rover',i10,/ ,'size'
     &   ,i10,/ ,'iwk(rover)',i10,/ ,'iwk(rover+size-1)',i10)
*
      end
