************************************************************************
**  ^ROUTINE: imem - allocate a block of space from a user array.
**
**
      integer function imem(iwk,usrsiz)
**  ^DESCRIPTION:
**       This routine allocates space from a user array.
**
**  ^AUTHOR:  mclay@vato.ae.utexas.edu  Mon Jul 19 21:50:38 1993
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:19:41 1994 $
**
**  ^REQUIREMENTS:  the array iwk must be initialized by iminit routine.
**
**  ^ALGORITHM:      This is a next fit allocation scheme.  See Knuth vol 1.
**
**  ^MACROS_USED:
*#    ASSERT - (^)
*#    ERRMEM - (^)
*#    HANDLE_ERROR - (^)
*#    IGETVSIZ - (^)
*#    IMPLICIT_NONE - (^)
*#    INCLUDE - (^)
*#    INITIALIZE - (^)
*#    NUSERBLKS - (^)
*#    NVOIDS - (^)
*#    ROVER - (^)
*#    SLOP - (^)
*#    VOID_BACKWARD - (^)
*#    VOID_FORWARD - (^)
**
****^^******************************************************************
*
      implicit none
*
       integer iwk(*)
      integer usrsiz
*
      integer aloc
      integer forwrd,bckwrd
      integer go
      integer nvoids
      integer rover
      integer usize
      integer vdsize
      integer vdstrt
      logical found
*
      logical imemck
      external imemck
*
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:19:41 1994 $
*     $Id: imem.fm4,v 1.7 1994/04/30 04:39:44 joubert Exp $
*     $Revision: 1.7 $
************************************************************************
*
      if (usrsiz .le. 0) then
        imem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['error usrsiz <= 0'])
      endif
      usize = usrsiz
      if (usize .lt. 3) usize = 3
*
      if (iwk(4) .ne. 4) then
        imem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error array not initialized'])
      endif
*
      rover = iwk(3)
      nvoids = iwk(5)
*
      found = .FALSE.
      if (nvoids .le. 0) then
        imem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,[' no voids left'])
      endif
*
      go = rover
 8511 continue
        vdsize = iwk(rover)
        if (iwk(rover) .ne. iwk(rover+vdsize-1)) then
          imem = 0
          go to 900
**#       HANDLE_ERROR(ERRMEM,['Boundary words do not match'])
        endif
        if (vdsize .ge. usize + 2) then
          found = .TRUE.
          go to 8513
        endif
        rover = iwk(rover+1)
      if (.not. (rover .eq. go)) go to 8511
 8513 continue
*
      if (.not. found) then
        imem = 0
        go to 900
**#     HANDLE_ERROR(ERRMEM,['Error: No void found'])
      endif
*
      if (vdsize - (usize + 2) .le. 12) then
*
        nvoids = nvoids - 1
        aloc = rover + 1
        forwrd = iwk(rover+1)
        bckwrd = iwk(rover+2)
*
        iwk(rover) = -vdsize
        iwk(rover+vdsize-1) = -vdsize
*
        iwk(forwrd+2) = bckwrd
        iwk(bckwrd+1) = forwrd
*
        if (rover .eq. go) then
          rover = iwk(go+1)
        else
          rover = go
        endif
      else
*
        aloc = rover + 1
        vdstrt = rover + usize + 2
        vdsize = vdsize - (usize + 2)
        forwrd = iwk(rover+1)
        bckwrd = iwk(rover+2)
*
        if (forwrd .eq. rover) forwrd = vdstrt
        if (bckwrd .eq. rover) bckwrd = vdstrt
*
        iwk(vdstrt) = vdsize
        iwk(vdstrt + vdsize - 1) = vdsize
*
        iwk(vdstrt+1) = forwrd
        iwk(vdstrt+2) = bckwrd
*
        iwk(bckwrd+1) = vdstrt
        iwk(forwrd+2) = vdstrt
*
        iwk(rover) = -(usize + 2)
        iwk(rover + usize + 1) = -(usize + 2)
*
        if (rover .eq. go) then
          rover = vdstrt
        else
          rover = go
        endif
*
      endif
*
      iwk(2) = max(iwk(2),aloc+usize+1)
*
      iwk(3) = rover
      iwk(5) = nvoids
      imem = aloc
*
      iwk(6) = iwk(6) + 1
      if (.not. imemck(iwk)) then
        imem = 0
        go to 900
      endif
*
  900 continue
      return
      end
