************************************************************************
** ^ROUTINE: imaxgr - Compute indexing polynomial for matrix,
**                    Regular Grid format.
**                       (^)
      integer function imaxgr (ibr,ibc,isten,is,maxord,nb,ns,nsten)
**
** ^DESCRIPTION:
**    Computes (1-based) indexing polynomial for matrix in regular
**    grid stencil format.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED:  wdj@lithos.c3.lanl.gov  Thu Mar  4 13:57:02 MST 1993
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Subroutines: See External declerations below
**
** ^SIDE_EFFECTS:
**
** ^ALGORITHM:
**
** ^REFERENCES:
**
** ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
      integer ibr
      integer ibc
      integer isten
      integer is
      integer maxord
      integer nb, ns, nsten
*
      integer maxeff
*
****^^******************************************************************
*     $Modified: wdj@lanl.gov
*     $Id: imaxgr.fm4,v 1.3 1994/10/26 19:22:35 joubert Exp $
*     $Revision: 1.3 $
************************************************************************
*
      maxeff = maxord
         if (maxeff .eq. -1) maxeff = 18
*
      go to (101,102,103,104,105,106, 107,108,109,110,111,112, 113,114,
     &   115,116,117,118, 119,120,121,122,123,124) 1+maxeff
*
  101 continue
      imaxgr = 1 + (ibr -1 + nb * (ibc -1 + nb * (isten-1 + nsten* (is -
     &   1 + ns * 0))))
      return
*
  102 continue
      imaxgr = 1 + (ibr -1 + nb * (ibc -1 + nb * (is -1 + ns * (isten-1 
     &   + nsten* 0))))
      return
*
  103 continue
      imaxgr = 1 + (ibr -1 + nb * (isten-1 + nsten* (ibc -1 + nb * (is -
     &   1 + ns * 0))))
      return
*
  104 continue
      imaxgr = 1 + (ibr -1 + nb * (isten-1 + nsten* (is -1 + ns * (ibc -
     &   1 + nb * 0))))
      return
*
  105 continue
      imaxgr = 1 + (ibr -1 + nb * (is -1 + ns * (ibc -1 + nb * (isten-1 
     &   + nsten* 0))))
      return
*
  106 continue
      imaxgr = 1 + (ibr -1 + nb * (is -1 + ns * (isten-1 + nsten* (ibc -
     &   1 + nb * 0))))
      return
*
  107 continue
      imaxgr = 1 + (ibc -1 + nb * (ibr -1 + nb * (isten-1 + nsten* (is -
     &   1 + ns * 0))))
      return
*
  108 continue
      imaxgr = 1 + (ibc -1 + nb * (ibr -1 + nb * (is -1 + ns * (isten-1 
     &   + nsten* 0))))
      return
*
  109 continue
      imaxgr = 1 + (ibc -1 + nb * (isten-1 + nsten* (ibr -1 + nb * (is -
     &   1 + ns * 0))))
      return
*
  110 continue
      imaxgr = 1 + (ibc -1 + nb * (isten-1 + nsten* (is -1 + ns * (ibr -
     &   1 + nb * 0))))
      return
*
  111 continue
      imaxgr = 1 + (ibr -1 + nb * (ibc -1 + nb * (isten-1 + nsten* (is -
     &   1 + ns * 0))))
      return
*
  112 continue
      imaxgr = 1 + (ibc -1 + nb * (is -1 + ns * (isten-1 + nsten* (ibr -
     &   1 + nb * 0))))
      return
*
  113 continue
      imaxgr = 1 + (isten-1 + nsten* (ibr -1 + nb * (ibc -1 + nb * (is -
     &   1 + ns * 0))))
      return
*
  114 continue
      imaxgr = 1 + (isten-1 + nsten* (ibr -1 + nb * (is -1 + ns * (ibc -
     &   1 + nb * 0))))
      return
*
  115 continue
      imaxgr = 1 + (isten-1 + nsten* (ibc -1 + nb * (ibr -1 + nb * (is -
     &   1 + ns * 0))))
      return
*
  116 continue
      imaxgr = 1 + (isten-1 + nsten* (ibc -1 + nb * (is -1 + ns * (ibr -
     &   1 + nb * 0))))
      return
*
  117 continue
      imaxgr = 1 + (isten-1 + nsten* (is -1 + ns * (ibr -1 + nb * (ibc -
     &   1 + nb * 0))))
      return
*
  118 continue
      imaxgr = 1 + (isten-1 + nsten* (is -1 + ns * (ibc -1 + nb * (ibr -
     &   1 + nb * 0))))
      return
*
  119 continue
      imaxgr = 1 + (is -1 + ns * (ibr -1 + nb * (ibc -1 + nb * (isten-1 
     &   + nsten* 0))))
      return
*
  120 continue
      imaxgr = 1 + (is -1 + ns * (ibr -1 + nb * (isten-1 + nsten* (ibc -
     &   1 + nb * 0))))
      return
*
  121 continue
      imaxgr = 1 + (is -1 + ns * (ibc -1 + nb * (ibr -1 + nb * (isten-1 
     &   + nsten* 0))))
      return
*
  122 continue
      imaxgr = 1 + (is -1 + ns * (ibc -1 + nb * (isten-1 + nsten* (ibr -
     &   1 + nb * 0))))
      return
*
  123 continue
      imaxgr = 1 + (is -1 + ns * (isten-1 + nsten* (ibr -1 + nb * (ibc -
     &   1 + nb * 0))))
      return
*
  124 continue
      imaxgr = 1 + (is -1 + ns * (isten-1 + nsten* (ibc -1 + nb * (ibr -
     &   1 + nb * 0))))
      return
*
      end
