************************************************************************
** ^ROUTINE:  ilog2 - integer log (base 2) function. (^)
**
      integer function ilog2 (n)
**
** ^DESCRIPTION:
**    Returns the ceiling of the base-2 log of an integer.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:55 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
** ^SIDE_EFFECTS:
**
************************************************************************
      implicit none
      integer n
      integer ntemp
      integer nret
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:55 1994 $
*     $Id: ilog2.fm4,v 1.5 1994/02/04 03:02:55 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
      ntemp = n
      nret = 0
    1 continue
      if (ntemp .le. 1) go to 2
      nret = nret + 1
      ntemp = (ntemp+1) / 2
      go to 1
    2 continue
      ilog2 = nret
      return
      end
