************************************************************************
** ^ROUTINE: ii2mi - convert multiindex to regular index. (^)
**
      subroutine ii2mi (imi,ielt,ndim,nsg)
**
** ^DESCRIPTION:
**    Converts a multiindex, represented in the bases in nsg of size ndim,
**    to a single index.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:56 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**
************************************************************************
      implicit none
      integer ielt
      integer ndim
      integer imi(*)
      integer nsg(*)
      integer i
      integer itmp
      integer imodf
      external imodf
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:56 1994 $
*     $Id: ii2mi.fm4,v 1.5 1994/02/04 03:02:53 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
      itmp = ielt
      do 8511 i = 1, ndim
        imi(i) = imodf(itmp,nsg(i))
        itmp = (itmp-imi(i))/nsg(i)
 8511 continue
      return
      end
