************************************************************************
**  ^ROUTINE: igrid - map from processor number to subgrid number. (^)
**
      integer function igrid (iproc,ndim,npax)
**
**  ^DESCRIPTION:
**
**    Maps from machine processor number to (natural ordering) subgrid
**    number.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:59 1994 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED: see below.
**
************************************************************************
      implicit none
      integer iproc
      integer ndim
      integer npax(*)
      integer iprdax
      integer itmp
      integer nprcax
      integer iprcax
      integer iaxis
      integer imodf
      external imodf
      integer ibin
      external ibin
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:59 1994 $
*     $Id: igrid.fm4,v 1.6 1994/02/04 03:02:50 joubert Exp $
*     $Revision: 1.6 $
************************************************************************
      igrid = 0
      itmp = iproc
      iprdax = 1
      do 8511 iaxis = 1, ndim
        nprcax = npax(iaxis)
        iprcax = imodf(itmp,nprcax)
        if (npax(ndim+iaxis) .eq. 1) then
          igrid = igrid + iprdax*ibin(iprcax)
        else
          igrid = igrid + iprdax*(iprcax)
        endif
        itmp = (itmp-iprcax)/nprcax
        iprdax = iprdax*nprcax
 8511 continue
      return
      end
