************************************************************************
** ^ROUTINE: ifloor - integer floor function. (^)
**
      integer function ifloor (inum,idenom)
**
** ^DESCRIPTION:
**    Computes the integer floor function of the ratio of two integers.
**
** ^AUTHOR:    wdj@beta.lanl.gov
**
** ^MODIFIED: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:54 1994 $
**
** ^ARGUMENTS: see *Subroutine Arguments* below.
**
** ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   imodf
**    The second argument "idenom" must be positive.
**
** ^SIDE_EFFECTS:
**
** ^DOCUMENTATION:
**
************************************************************************
      implicit none
      integer inum
      integer idenom
      integer imodf
      external imodf
****^^******************************************************************
*     $Modified: mclay@zoyd.ae.utexas.edu on Thu Jan 20 16:52:54 1994 $
*     $Id: ifloor.fm4,v 1.5 1994/02/04 03:02:44 joubert Exp $
*     $Revision: 1.5 $
************************************************************************
      ifloor = (inum-imodf(inum,idenom)) / idenom
      return
      end
