************************************************************************
**  ^ROUTINE: WWGETE - Routine to get an entry of a vector. (^)
**
      subroutine dwgete ( v , procb, entryb, proce, entrye, values, 
     &   iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**
**  ^AUTHOR:  wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:00:54 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    BASICAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  BASICAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
      integer procb
      integer entryb
      integer proce
      integer entrye
       double precision v(*)
      double precision values(*)
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      integer ibeg, iend, iproc, size, itmp, icomwk, iptr, i
*
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:54 1996 $
*     $Id: wgete.fm4,v 1.2 1994/11/22 05:18:57 joubert Exp $
************************************************************************
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      icomwk = (iparm(6))
*
      if (procb.lt.0 .or. procb.gt.nproc-1) goto 900
      if (proce.lt.0 .or. proce.gt.nproc-1) goto 900
*
      if (ipme .eq. procb) then
        ibeg = entryb
      else if (ipme .gt. procb) then
        ibeg = 1
      else
        ibeg = iparm(3) + 1
      endif
      if (ipme .eq. proce) then
        iend = entrye
      else if (ipme .lt. proce) then
        iend = iparm(3)
      else
        iend = 0
      endif
*
        iptr = 1
        do 8511 iproc = procb, proce
          if (iproc .eq. ipme) then
            size = iend - ibeg + 1
          else
            size = 0
          endif
          call xgladd (1,size,itmp, iparm , fparm , iwk , fwk , ier )
      call dfmal (icomwk,size, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          if (iproc .eq. ipme) then
             do 8513 i = ibeg, ibeg-1+size
      values(iptr+i-ibeg) = v(i)
 8513 continue
          else
             do 8515 i = ibeg, ibeg-1+size
      values(iptr+i-ibeg) = 0d0
 8515 continue
          endif
                call gdsum(values(iptr),1*(size),fwk(icomwk))
      call dffre (icomwk,size, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
          iptr = iptr + size
 8511   continue
*
  900 continue
*
      return
      end
