************************************************************************
**  ^ROUTINE: WWADD - Routine to add two vectors and put the result in
**                   a third (^)
**
      subroutine dwadd ( vo , v , w , iparm , fparm , iwk , fwk , ier )
**
**  ^DESCRIPTION:
**    Simply adds the vector w to v and puts the result in vo.  This routine is
**    part of the Low-level level-1 BLAS-type routine required by pcg package.
**    Written for Sun, Cray YMP, Ncube, iPSC 860, or generic f77; as set by m4
*#    variable MACHINE.
**
**    On a Cray YMP the vector is partitioned out to all available processors.
**    The partitioning is done using compiler directives, thus the complier
**    decides how the partitioning is done.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:00:56 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**    Basic vector addition
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**  ^SUBROUTINES USED:
**    See "Externals" section below for any subroutines used.
**
************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*#    BASICAL             - An argument list which is common to nearly all
*#                        internal routines of the package.  BASICAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                        iwffre - (int) next free location in fwk
*#                        iwifre - (int) next free location in iwk
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       double precision vo(*)
       double precision v(*)
       double precision w(*)
      integer nv
      integer i
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:00:56 1996 $
*     $Id: wadd.fm4,v 1.8 1994/04/21 04:18:33 joubert Exp $
*     $Revision: 1.8 $
************************************************************************
      nv = iparm(3)
           do 8511 i = 1, (nv-(1)+1)/(8)*(8)+1-1, 8
              vo((i+0)) = v((i+0)) + w((i+0))
              vo((i+1)) = v((i+1)) + w((i+1))
              vo((i+2)) = v((i+2)) + w((i+2))
              vo((i+3)) = v((i+3)) + w((i+3))
              vo((i+4)) = v((i+4)) + w((i+4))
              vo((i+5)) = v((i+5)) + w((i+5))
              vo((i+6)) = v((i+6)) + w((i+6))
              vo((i+7)) = v((i+7)) + w((i+7))
 8511         continue
              do 8513 i = (nv-(1)+1)/(8)*(8)+1, nv
              vo(i) = v(i) + w(i)
 8513         continue
      fparm(3) = fparm(3) + (1.*nv)
      return
      end
