************************************************************************
**  ^ROUTINE: WSCGR - Grid-based matrix matrix scaling routine.
**                      (^)
**
      subroutine dscgr ( ijob , ia , ja , a , u , uexact , b , iwk , 
     &   fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    Wrapper routine to apply/undo scaling to a matrix or scale vectors.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:02 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   none
**
**  ^SIDE_EFFECTS:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    PREPAL           - An argument list which is common to nearly all
*#                        internal routines of the package.  ALLAL is used in
*#                        calls to fortran routines.
*#                    !---Subroutine Names as Arguments:
*#                        suba - matvec routine
*#                        subq - preconditioning routine
*#                    !---Integer Scalars:
*#                        ier - (int) error return value.
*#                    !---Integer Arrays:
*#                        ia - (int) used to store indexing information for
*#                            non-zero elements of matrix stored in a.
*#                        iparm - (int) used to pass integer parameters to and
*#                            from the package.
*#                        iq - (int) used along with floating point array q
*#                            and subroutine subq for preconditioning.
*#                        iwk - (int) integer workspace
*#                    !---Float Arrays:
*#                        a - (float) array used to store non-zero elements
*#                            of the matrix A.
*#                        b - (float) right hand side of the linear system.
*#                        fparm - (float) used to pass floating point
*#                            parameters to and from the package.
*#                        fwk - (float) floating work array space
*#                        q - (float) used along with integer array iq and
*#                            subroutine subq for preconditioning
*#                        u - (float) solution vector. On input it contains
*#                            the initial guess.
*#                        ubar - (float) exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       double precision a(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
      external ximini
      external ximal
      external xifre
      external dfmini
      external dfmal
      external dffre
      integer nv
      integer ndim
      integer nsten
      integer nb
      integer ns
      integer imaxgr
      external imaxgr
      integer ivaxgr
      external ivaxgr
      integer itab
      integer idiag1
      integer idiag2
      integer imdiag
      integer isscll, issclr
      integer idbufp
      integer idbufl
      integer ncpprd
      integer ielt
      integer nelt
      integer iaxin1, iaxin2
      integer ivip
      integer iap
      integer islno
      integer iaxis
      integer isten
      integer is
      integer ibr
      integer ibc
      integer iin1, iin2
      integer nin1, nin2
      integer istrd1
      integer istrd2
      integer ivstr1
      integer ivstr2
      integer ivstrr
      integer imstr1
      integer imstr2
      integer imstrr
      integer imstrc
          integer iprc
          integer ibuf
          integer ipsend
          integer iprecv
          integer ibstrr
          integer ibstrc
          integer ibstr1
          integer ibstr2
          integer inelrp
          integer iprdax
          integer ninb1, ninb2
      integer imins (32)
      integer imind (32)
      integer inelt (32)
          integer iminr (32)
          integer imaxr (32)
          integer inelr (32)
          integer iminc (32)
          integer imaxc (32)
          integer imi (32)
          integer iprcmi(32)
          integer imi2 (32)
          integer imi3 (32)
          integer ncpmin(32)
          integer ncpmax(32)
          integer ncp (32)
      double precision dmin
          double precision dtmp
*
      integer islice
      external islice
          external dglmin
          integer ifloor
          external ifloor
          integer imi2i
          external imi2i
          integer imodf
          external imodf
          external xslice
          integer igrid
          external igrid
          integer iproc
          external iproc
*
**#   NTAB - size of the saved table
**#   IOFST - stencil offset extracted from ja
**#   NSBGR - number of subgrid points along an axis
**#   NPROCS - number of processors along an axis
*
*=======================================================================
*#    GET_CIRCUM_RECT(ipm)
*#                      - fill out iminc/imaxc, the extents of the
*#                        circumscribing rectangle, in grid points.
*#                        ipm=1 regular case, -1 transpose case.
*#                        (^)
*
*=======================================================================
*#    GET_CA_PROCS(ipm)
*#                      - fill out ncpmin/max, ncp, ncpprd, the information
*#                        on the communication active processors.
*#                        (^)
*
*=======================================================================
*#    GET_IPSEND_IPRECV(ipm)
*#                      - fill out ipsend/iprecv based on iprc and ncp*.
*#                        Also fill out iprcmi, the multiindex of iprc in the
*#                        ncpmin/max coord system.
*#                        imi2/3 temporaries.
*#                        (^)
*
*=======================================================================
*#    CHECK_WHETHER_BUFFER_NEEDED(ipm)
*#                      - figure out whether we will really need to use
*#                        anything from the processor in question.
*#                        Assumes iprcmi.
*#                        (^)
*
*=======================================================================
*#    GET_SUBGRID_INTERSECT_CIRCUM_RECT(ipm)
*#                      - fill out iminr/imaxr, the coords of the rectangle
*#                        that intersects the circumscribed rectangle and
*#                        the subgrid specified in iprcmi.  Also nelt.
*#                        (^)
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:02 1996 $
*     $Id: scgr.fm4,v 1.26 1994/11/22 05:19:53 joubert Exp $
*     $Revision: 1.26 $
************************************************************************
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
*
* Table semantics:
*         1 - pointer to left  vector
*         2 - pointer to right vector
*         3 - has left  scaling been applied yet
*         4 - has right scaling been applied yet
*         5 - pointer to table of buffer pointers
*         6 - pointer to table of buffer lengths
*         7 - size of table of buffer pointers
*
*
*-----------------------------------------------------------------------
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      itab = (iparm(6))
      idiag1 = (iparm(6))
      idiag2 = (iparm(6))
      idbufp = (iparm(6))
      idbufl = (iparm(6))
      isscll = 0
      issclr = 0
      ncpprd = 0
*
      nv = iparm(3 )
      ndim = ia (1 )
      nsten = ia (2)
      nb = ia (3 )
      ns = nv / nb
*
*-----------------------------------------------------------------------
*-------------------------------init case-------------------------------
*-----------------------------------------------------------------------
*
      if (ijob.eq.1) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
*
          go to 900
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
      call ximal (itab,7, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      call dfmal (idiag1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
           do 8511 ibr = 1, nb
       do 8513 is = 1, ns
      fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = 0d0
 8513 continue
 8511 continue
*
          if (iparm(41) .eq. 2) then
            imdiag = 0
            do 8515 isten = 1, nsten
              do 8517 iaxis = 1, ndim
                if (ja(iaxis+ndim*(isten-1)) .ne. 0) go to 10
 8517         continue
              imdiag = 1
               do 8519 ibr = 1, nb
       do 8521 is = 1, ns
      fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = fwk(idiag1-1+
     &   ivaxgr(ibr,is,ia(5),nb,ns,nsten)) + a ( imaxgr(ibr,ibr,isten,
     &   is,ia(4),nb,ns,nsten))
 8521 continue
 8519 continue
   10         continue
 8515       continue
            if (imdiag .eq. 0) then
                ier = -9
                call xersho ( ier, 'dscgr' , iparm , 'No main diagonal' 
     &             )
                go to 900
            endif
          else
             do 8523 ibr = 1, nb
       do 8525 is = 1, ns
      fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = 0d0
 8525 continue
 8523 continue
             do 8527 ibr = 1, nb
       do 8529 ibc = 1, nb
       do 8531 isten = 1, nsten
       do 8533 is = 1, ns
          fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = fwk(idiag1-1+
     &       ivaxgr(ibr,is,ia(5),nb,ns,nsten)) + abs(a ( imaxgr(ibr,ibc,
     &       isten,is,ia(4),nb,ns,nsten)))
 8533 continue
 8531 continue
 8529 continue
 8527 continue
            fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
          endif
*
          dmin = (abs(fwk(idiag1-1+ivaxgr(1,1,ia(5),nb,ns,nsten))))
           do 8535 ibr = 1, nb
       do 8537 is = 1, ns
      dmin = min((dmin), (abs(fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)))))
 8537 continue
 8535 continue
              call dglmin (1,dmin,dtmp, iparm , fparm , iwk , fwk , ier 
     &           )
           if (ier .lt. 0) go to 900
          if ((dmin) .eq. (0d0)) then
                ier = -9
                call xersho ( ier, 'dscgr' , iparm , 'Zero element found
     & on main diagonal' )
                go to 900
          endif
*
          go to 900
        endif
*
*---------------------------split diag scaling--------------------------
*
        if (iparm(41) .eq. 1) then
      call ximal (itab,7, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
      call dfmal (idiag1,iparm(3), iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
           do 8539 ibr = 1, nb
       do 8541 is = 1, ns
      fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = 0d0
 8541 continue
 8539 continue
*
          imdiag = 0
          do 8543 isten = 1, nsten
            do 8545 iaxis = 1, ndim
              if (ja(iaxis+ndim*(isten-1)) .ne. 0) go to 11
 8545       continue
            imdiag = 1
             do 8547 ibr = 1, nb
       do 8549 is = 1, ns
      fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = fwk(idiag1-1+
     &   ivaxgr(ibr,is,ia(5),nb,ns,nsten)) + a ( imaxgr(ibr,ibr,isten,
     &   is,ia(4),nb,ns,nsten))
 8549 continue
 8547 continue
   11       continue
 8543     continue
          if (imdiag .eq. 0) then
                ier = -9
                call xersho ( ier, 'dscgr' , iparm , 'No main diagonal' 
     &             )
                go to 900
          endif
*
           do 8551 ibr = 1, nb
       do 8553 is = 1, ns
          fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = sqrt((abs(
     &       fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten)))))
 8553 continue
 8551 continue
          fparm(23) = fparm(23) + (4.*nb*ns)
*
          dmin = (abs(fwk(idiag1-1+ivaxgr(1,1,ia(5),nb,ns,nsten))))
           do 8555 ibr = 1, nb
       do 8557 is = 1, ns
      dmin = min((dmin), (abs(fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)))))
 8557 continue
 8555 continue
              call dglmin (1,dmin,dtmp, iparm , fparm , iwk , fwk , ier 
     &           )
           if (ier .lt. 0) go to 900
          if ((dmin) .eq. (0d0)) then
                ier = -9
                call xersho ( ier, 'dscgr' , iparm , 'Zero element found
     & on main diagonal' )
                go to 900
          endif
          go to 900
        endif
*
*-----------------------------------------------------------------------
*
                ier = -5
                call xersho ( ier, 'dscgr' , iparm , 'Invalid scaling re
     &quest' )
                go to 900
*
*-----------------------------------------------------------------------
*
      else
        itab = iparm(11)
        if (itab .eq. (iparm(6))) go to 900
        idiag1 = iwk(itab+0)
        idiag2 = iwk(itab+1)
        isscll = iwk(itab+2)
        issclr = iwk(itab+3)
        idbufp = iwk(itab+4)
        idbufl = iwk(itab+5)
        ncpprd = iwk(itab+6)
      endif
*
*-----------------------------------------------------------------------
*------------------------------apply case-------------------------------
*-----------------------------------------------------------------------
*
      if (ijob.eq.3) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
          go to 900
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
           do 8559 ibr = 1, nb
       do 8561 ibc = 1, nb
       do 8563 isten = 1, nsten
       do 8565 is = 1, ns
      a( imaxgr(ibr,ibc,isten,is,ia(4),nb,ns,nsten)) = a( imaxgr(ibr,
     &   ibc,isten,is,ia(4),nb,ns,nsten)) / fwk(idiag1-1+ivaxgr(ibr,is,
     &   ia(5),nb,ns,nsten))
 8565 continue
 8563 continue
 8561 continue
 8559 continue
          fparm(23) = fparm(23) + (4.*nb*nb*nsten*ns)
          isscll = 1
           do 8567 ibr = 1, nb
       do 8569 is = 1, ns
      b(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = b(ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)) / fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8569 continue
 8567 continue
          fparm(23) = fparm(23) + (4.*nb*ns)
          go to 900
        endif
*
*-------------------------split scaling---------------------------------
*
        if (iparm(41) .eq. 1) then
           do 8571 ibr = 1, nb
       do 8573 ibc = 1, nb
       do 8575 isten = 1, nsten
       do 8577 is = 1, ns
      a( imaxgr(ibr,ibc,isten,is,ia(4),nb,ns,nsten)) = a( imaxgr(ibr,
     &   ibc,isten,is,ia(4),nb,ns,nsten)) / fwk(idiag1-1+ivaxgr(ibr,is,
     &   ia(5),nb,ns,nsten))
 8577 continue
 8575 continue
 8573 continue
 8571 continue
          fparm(23) = fparm(23) + (4.*nb*nb*nsten*ns)
          isscll = 1
          do 8579 iaxis = 1, ndim
            iminc(iaxis) = 0 +(-1)*ja(iaxis+ndim*(1 -1))
             do 8581 isten = 2, nsten
      iminc(iaxis) = min(iminc(iaxis), 0 +(-1)*ja(iaxis+ndim*(isten-1)))
 8581 continue
            imaxc(iaxis) = ja(iaxis+ndim*nsten)-1+(-1)*ja(iaxis+ndim*(1 
     &         -1))
             do 8583 isten = 2, nsten
      imaxc(iaxis) = max(imaxc(iaxis), ja(iaxis+ndim*nsten)-1 +(-1)*ja(
     &   iaxis+ndim*(isten-1)))
 8583 continue
 8579     continue
          ncpprd = 1
          do 8585 iaxis = 1, ndim
            ncpmin(iaxis) = ifloor(iminc(iaxis),ja(iaxis+ndim*nsten))
            ncpmax(iaxis) = ifloor(imaxc(iaxis),ja(iaxis+ndim*nsten))
            ncp (iaxis) = max(0,ncpmax(iaxis)-ncpmin(iaxis)+1)
            ncpprd = ncpprd * ncp(iaxis)
 8585     continue
      call ximal (idbufp,ncpprd, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call ximal (idbufl,ncpprd, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
           do 8587 iprc = 0, ncpprd-1
      iwk(idbufp+iprc) = (iparm(6))
 8587 continue
      if (iparm(26) + (ncpprd) + 0 - 1 .gt. iparm(25)) then
        if (iparm(26) + 0 - 1 .gt. iparm(25)) then
                ier = -12
                call xersho ( ier, 'dscgr' , iparm , 'Unable to perform 
     &synchronization' )
                go to 900
        endif
      call gsync ()
        iparm(26) = iparm(24)
      endif
          do 8589 iprc = 0, ncpprd-1
          call ii2mi (iprcmi,iprc,ndim,ncp)
           do 8591 iaxis = 1, ndim
      iprcmi(iaxis) = iprcmi(iaxis) + ncpmin(iaxis)
 8591 continue
          call ii2mi (imi2,igrid(ipme,ndim,ja(1+ndim*(nsten+1))),ndim,
     &       ja(1+ndim*(nsten+1)))
           do 8593 iaxis = 1, ndim
      imi3(iaxis) = imodf(imi2(iaxis)+iprcmi(iaxis), ja(iaxis+ndim*(
     &   nsten+1)))
 8593 continue
          ipsend = iproc(imi2i(imi3,ndim,ja(1+ndim*(nsten+1))),ndim,ja(
     &       1+ndim*(nsten+1)))
           do 8595 iaxis = 1, ndim
      imi3(iaxis) = imodf(imi2(iaxis)-iprcmi(iaxis), ja(iaxis+ndim*(
     &   nsten+1)))
 8595 continue
          iprecv = iproc(imi2i(imi3,ndim,ja(1+ndim*(nsten+1))),ndim,ja(
     &       1+ndim*(nsten+1)))
          if (-1 .eq. +1) then
             do 8597 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8597 continue
      else
             do 8599 iaxis = 1, ndim
      imi2(iaxis) = ncpmax(iaxis) - iprcmi(iaxis)
 8599 continue
      endif
          ibuf = imi2i (imi2,ndim,ncp)
           if (ipsend .eq. ipme) go to 8589
           do 8601 isten = 1, nsten
             do 8603 iaxis = 1, ndim
               if (max(min((-1)*ja(iaxis+ndim*(isten-1)),1),-1) .ne. 
     &            max(min(iprcmi(iaxis) ,1),-1) ) go to 5500
 8603        continue
             go to 5501
 5500       continue
 8601      continue
           go to 8589
 5501      continue
           inelrp = 1
           do 8605 iaxis = 1, ndim
             iminr(iaxis) = max(0 , iminc(iaxis)+ja(iaxis+ndim*nsten)*
     &          iprcmi(iaxis))
             imaxr(iaxis) = min(ja(iaxis+ndim*nsten)-1, imaxc(iaxis)+ja(
     &          iaxis+ndim*nsten)*iprcmi(iaxis))
             inelr(iaxis) = max(0,imaxr(iaxis)-iminr(iaxis)+1)
             inelrp = inelrp * inelr(iaxis)
 8605      continue
            iwk( idbufl+ibuf) = inelrp*nb
      call dfmal (iwk(idbufp+ibuf),iwk(idbufl+ibuf), iparm , fparm , 
     &   iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 8589     continue
*
      if (iparm(26) + (ncpprd) + 0 - 1 .gt. iparm(25)) then
        if (iparm(26) + 0 - 1 .gt. iparm(25)) then
                ier = -12
                call xersho ( ier, 'dscgr' , iparm , 'Unable to perform 
     &synchronization' )
                go to 900
        endif
      call gsync ()
        iparm(26) = iparm(24)
      endif
          do 8607 iprc = 0, ncpprd-1
          call ii2mi (iprcmi,iprc,ndim,ncp)
           do 8609 iaxis = 1, ndim
      iprcmi(iaxis) = iprcmi(iaxis) + ncpmin(iaxis)
 8609 continue
          call ii2mi (imi2,igrid(ipme,ndim,ja(1+ndim*(nsten+1))),ndim,
     &       ja(1+ndim*(nsten+1)))
           do 8611 iaxis = 1, ndim
      imi3(iaxis) = imodf(imi2(iaxis)+iprcmi(iaxis), ja(iaxis+ndim*(
     &   nsten+1)))
 8611 continue
          ipsend = iproc(imi2i(imi3,ndim,ja(1+ndim*(nsten+1))),ndim,ja(
     &       1+ndim*(nsten+1)))
           do 8613 iaxis = 1, ndim
      imi3(iaxis) = imodf(imi2(iaxis)-iprcmi(iaxis), ja(iaxis+ndim*(
     &   nsten+1)))
 8613 continue
          iprecv = iproc(imi2i(imi3,ndim,ja(1+ndim*(nsten+1))),ndim,ja(
     &       1+ndim*(nsten+1)))
          if (-1 .eq. +1) then
             do 8615 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8615 continue
      else
             do 8617 iaxis = 1, ndim
      imi2(iaxis) = ncpmax(iaxis) - iprcmi(iaxis)
 8617 continue
      endif
          ibuf = imi2i (imi2,ndim,ncp)
           if (ipsend .eq. ipme) go to 8607
           do 8619 isten = 1, nsten
             do 8621 iaxis = 1, ndim
               if (max(min((-1)*ja(iaxis+ndim*(isten-1)),1),-1) .ne. 
     &            max(min(iprcmi(iaxis) ,1),-1) ) go to 5502
 8621        continue
             go to 5503
 5502       continue
 8619      continue
           go to 8607
 5503      continue
           inelrp = 1
           do 8623 iaxis = 1, ndim
             iminr(iaxis) = max(0 , iminc(iaxis)+ja(iaxis+ndim*nsten)*
     &          iprcmi(iaxis))
             imaxr(iaxis) = min(ja(iaxis+ndim*nsten)-1, imaxc(iaxis)+ja(
     &          iaxis+ndim*nsten)*iprcmi(iaxis))
             inelr(iaxis) = max(0,imaxr(iaxis)-iminr(iaxis)+1)
             inelrp = inelrp * inelr(iaxis)
 8623      continue
            call xplane ( ja(1+ndim*nsten), inelt, ia, iparm, iaxin1, 
     &         iaxin2, istrd1, istrd2, nin1, nin2, ivstrr,ivstr1,ivstr2,
     &          imstrr,imstrc,imstr1,imstr2)
            ibstrr = 1
            ibstr1 = nb
            ibstr2 = nb*nin1
            do 8625 ielt = 0, inelrp-1, nin1*nin2
              ivip = ivaxgr(1,1+islice(ielt,ndim,ja(1+ndim*nsten),inelr,
     &           iminr),ia(5),nb,ns,nsten)
               do 8627 iin2 = 0, nin2-1
       do 8629 iin1 = 0, nin1-1
       do 8631 ibr = 0, nb-1
      fwk(iwk(idbufp+ibuf) +ielt*nb+ibr*ibstrr+iin1*ibstr1+iin2*ibstr2) 
     &   = fwk(idiag1-1+ivip+ibr*ivstrr+iin1*ivstr1+iin2*ivstr2)
 8631 continue
 8629 continue
 8627 continue
 8625       continue
      call csend ((iparm(26)), fwk(iwk(idbufp+ibuf)), 8*(iwk(idbufl+
     &   iprc)), (ipsend), 0)
      call crecv ((iparm(26)), fwk(iwk(idbufp+ibuf)), 8*(iwk(idbufl+
     &   iprc)))
            iparm(26) = iparm(26) + 1
 8607     continue
          do 8633 isten = 1, nsten
            do 8635 islno = 0, 2**ndim-1
              call xslice ( ia, ja, isten, islno, 4, imins, imind, 
     &           inelt, nelt , ipme, ipsend, iprecv, iprcmi )
              if (nelt .eq. 0) go to 8635
              if (iprecv .eq. ipme) then
              call xplane ( ja(1+ndim*nsten), inelt, ia, iparm, iaxin1, 
     &           iaxin2, istrd1, istrd2, nin1, nin2, ivstrr,ivstr1,
     &           ivstr2, imstrr,imstrc,imstr1,imstr2)
              do 8637 ielt = 0, nelt-1, nin1*nin2
                ivip = ivaxgr(1,1+islice(ielt,ndim,ja(1+ndim*nsten),
     &             inelt,imind),ia(5),nb,ns,nsten)
                iap = imaxgr(1,1,isten,1+islice(ielt,ndim,ja(1+ndim*
     &             nsten),inelt,imind),ia(4),nb,ns,nsten)
                 do 8639 iin1 = 0, nin1-1
       do 8641 iin2 = 0, nin2-1
       do 8643 ibr = 0, nb-1
       do 8645 ibc = 0, nb-1
      a (iap +ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2) = a (iap +
     &   ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2)/ fwk(idiag1-1+ 
     &   ivip+ibc*ivstrr+iin1*ivstr1+iin2*ivstr2)
 8645 continue
 8643 continue
 8641 continue
 8639 continue
 8637         continue
              else
                 do 8647 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8647 continue
                iprc = imi2i (imi2,ndim,ncp)
                call ii2mi (iprcmi,iprc,ndim,ncp)
                 do 8649 iaxis = 1, ndim
      iprcmi(iaxis) = iprcmi(iaxis) + ncpmin(iaxis)
 8649 continue
                ibuf = iprc
                if (-1 .eq. +1) then
                    do 8651 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8651 continue
                else
                    do 8653 iaxis = 1, ndim
      imi2(iaxis) = ncpmax(iaxis) - iprcmi(iaxis)
 8653 continue
                endif
                ibuf = imi2i (imi2,ndim,ncp)
                call xplane ( ja(1+ndim*nsten), inelt, ia, iparm, 
     &             iaxin1, iaxin2, istrd1, istrd2, nin1, nin2, ivstrr,
     &             ivstr1,ivstr2, imstrr,imstrc,imstr1,imstr2)
*
           inelrp = 1
           do 8655 iaxis = 1, ndim
             iminr(iaxis) = max(0 , iminc(iaxis)+ja(iaxis+ndim*nsten)*
     &          iprcmi(iaxis))
             imaxr(iaxis) = min(ja(iaxis+ndim*nsten)-1, imaxc(iaxis)+ja(
     &          iaxis+ndim*nsten)*iprcmi(iaxis))
             inelr(iaxis) = max(0,imaxr(iaxis)-iminr(iaxis)+1)
             inelrp = inelrp * inelr(iaxis)
 8655      continue
*
                iprdax = 1
                do 8657 iaxis = 1, ndim
                  if (iaxis .eq. iaxin1) ninb1 = iprdax
                  if (iaxis .eq. iaxin2) ninb2 = iprdax
                  iprdax = iprdax * inelr(iaxis)
 8657           continue
*
                ibstrr = 1
                ibstrc = nb*inelrp
                ibstr1 = nb*ninb1
                ibstr2 = nb*ninb2
                 do 8659 iaxis = 1, ndim
      imi(iaxis) = imins(iaxis) - iminr(iaxis)
 8659 continue
                do 8661 ielt = 0, nelt-1, nin1*nin2
                  ivip = iwk(idbufp+ibuf) + nb*islice(ielt,ndim,inelr, 
     &               inelt,imi )
                  iap = imaxgr(1,1,isten,1+islice(ielt,ndim,ja(1+ndim*
     &               nsten),inelt,imind),ia(4),nb,ns,nsten)
                   do 8663 iin2 = 0, nin2-1
       do 8665 iin1 = 0, nin1-1
       do 8667 ibr = 0, nb-1
       do 8669 ibc = 0, nb-1
      a (iap +ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2) = a (iap +
     &   ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2)/ fwk(ivip+ibc*
     &   ibstrr+iin1*ibstr1+iin2*ibstr2)
 8669 continue
 8667 continue
 8665 continue
 8663 continue
 8661           continue
              endif
 8635       continue
 8633     continue
          fparm(23) = fparm(23) + (4.*nb*nb*nsten*ns)
          issclr = 1
           do 8671 ibr = 1, nb
       do 8673 is = 1, ns
      b(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = b(ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)) / fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8673 continue
 8671 continue
          fparm(23) = fparm(23) + (4.*nb*ns)
          if (((iparm(14).eq.0).or.(iparm(14).eq.1) .or.(iparm(14).eq.3)
     &       )) then
             do 8675 ibr = 1, nb
       do 8677 is = 1, ns
      u(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = u(ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)) * fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8677 continue
 8675 continue
            fparm(23) = fparm(23) + (1.*nb*ns)
          endif
          if (iparm(19) .eq. 1) then
             do 8679 ibr = 1, nb
       do 8681 is = 1, ns
      uexact(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = uexact(ivaxgr(ibr,is,
     &   ia(5),nb,ns,nsten)) * fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten))
 8681 continue
 8679 continue
            fparm(23) = fparm(23) + (1.*nb*ns)
          endif
          go to 900
        endif
*
*-----------------------------------------------------------------------
*
      endif
*
*-----------------------------------------------------------------------
*----------------------------unapply case-------------------------------
*-----------------------------------------------------------------------
*
      if (ijob.eq.4) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
          go to 900
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
           do 8683 ibr = 1, nb
       do 8685 is = 1, ns
      b(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = b(ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)) * fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8685 continue
 8683 continue
          fparm(23) = fparm(23) + (1.*nb*ns)
          if (isscll .eq. 1) then
             do 8687 ibr = 1, nb
       do 8689 ibc = 1, nb
       do 8691 isten = 1, nsten
       do 8693 is = 1, ns
      a( imaxgr(ibr,ibc,isten,is,ia(4),nb,ns,nsten)) = a( imaxgr(ibr,
     &   ibc,isten,is,ia(4),nb,ns,nsten)) * fwk(idiag1-1+ivaxgr(ibr,is,
     &   ia(5),nb,ns,nsten))
 8693 continue
 8691 continue
 8689 continue
 8687 continue
            fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
            isscll = 0
          endif
          go to 900
        endif
*
*----------------------split diag scaling-------------------------------
*
        if (iparm(41) .eq. 1) then
          if (isscll .eq. 1) then
             do 8695 ibr = 1, nb
       do 8697 ibc = 1, nb
       do 8699 isten = 1, nsten
       do 8701 is = 1, ns
      a( imaxgr(ibr,ibc,isten,is,ia(4),nb,ns,nsten)) = a( imaxgr(ibr,
     &   ibc,isten,is,ia(4),nb,ns,nsten)) * fwk(idiag1-1+ivaxgr(ibr,is,
     &   ia(5),nb,ns,nsten))
 8701 continue
 8699 continue
 8697 continue
 8695 continue
            fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
            isscll = 0
          endif
          if (issclr .eq. 1) then
          do 8703 isten = 1, nsten
            do 8705 islno = 0, 2**ndim-1
              call xslice ( ia, ja, isten, islno, 4, imins, imind, 
     &           inelt, nelt , ipme, ipsend, iprecv, iprcmi )
              if (nelt .eq. 0) go to 8705
              if (iprecv .eq. ipme) then
              call xplane ( ja(1+ndim*nsten), inelt, ia, iparm, iaxin1, 
     &           iaxin2, istrd1, istrd2, nin1, nin2, ivstrr,ivstr1,
     &           ivstr2, imstrr,imstrc,imstr1,imstr2)
              do 8707 ielt = 0, nelt-1, nin1*nin2
                ivip = ivaxgr(1,1+islice(ielt,ndim,ja(1+ndim*nsten),
     &             inelt,imind),ia(5),nb,ns,nsten)
                iap = imaxgr(1,1,isten,1+islice(ielt,ndim,ja(1+ndim*
     &             nsten),inelt,imind),ia(4),nb,ns,nsten)
                 do 8709 iin1 = 0, nin1-1
       do 8711 iin2 = 0, nin2-1
       do 8713 ibr = 0, nb-1
       do 8715 ibc = 0, nb-1
      a (iap +ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2) = a (iap +
     &   ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2)* fwk(idiag1-1+ 
     &   ivip+ibc*ivstrr+iin1*ivstr1+iin2*ivstr2)
 8715 continue
 8713 continue
 8711 continue
 8709 continue
 8707         continue
              else
                 do 8717 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8717 continue
                iprc = imi2i (imi2,ndim,ncp)
                call ii2mi (iprcmi,iprc,ndim,ncp)
                 do 8719 iaxis = 1, ndim
      iprcmi(iaxis) = iprcmi(iaxis) + ncpmin(iaxis)
 8719 continue
                ibuf = iprc
                if (-1 .eq. +1) then
                    do 8721 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8721 continue
                else
                    do 8723 iaxis = 1, ndim
      imi2(iaxis) = ncpmax(iaxis) - iprcmi(iaxis)
 8723 continue
                endif
                ibuf = imi2i (imi2,ndim,ncp)
                call xplane ( ja(1+ndim*nsten), inelt, ia, iparm, 
     &             iaxin1, iaxin2, istrd1, istrd2, nin1, nin2, ivstrr,
     &             ivstr1,ivstr2, imstrr,imstrc,imstr1,imstr2)
           inelrp = 1
           do 8725 iaxis = 1, ndim
             iminr(iaxis) = max(0 , iminc(iaxis)+ja(iaxis+ndim*nsten)*
     &          iprcmi(iaxis))
             imaxr(iaxis) = min(ja(iaxis+ndim*nsten)-1, imaxc(iaxis)+ja(
     &          iaxis+ndim*nsten)*iprcmi(iaxis))
             inelr(iaxis) = max(0,imaxr(iaxis)-iminr(iaxis)+1)
             inelrp = inelrp * inelr(iaxis)
 8725      continue
*
                iprdax = 1
                do 8727 iaxis = 1, ndim
                  if (iaxis .eq. iaxin1) ninb1 = iprdax
                  if (iaxis .eq. iaxin2) ninb2 = iprdax
                  iprdax = iprdax * inelr(iaxis)
 8727           continue
*
                ibstrr = 1
                ibstrc = nb*inelrp
                ibstr1 = nb*ninb1
                ibstr2 = nb*ninb2
                 do 8729 iaxis = 1, ndim
      imi(iaxis) = imins(iaxis) - iminr(iaxis)
 8729 continue
                do 8731 ielt = 0, nelt-1, nin1*nin2
                  ivip = iwk(idbufp+ibuf) + nb*islice(ielt,ndim,inelr, 
     &               inelt,imi )
                  iap = imaxgr(1,1,isten,1+islice(ielt,ndim,ja(1+ndim*
     &               nsten),inelt,imind),ia(4),nb,ns,nsten)
                   do 8733 iin2 = 0, nin2-1
       do 8735 iin1 = 0, nin1-1
       do 8737 ibr = 0, nb-1
       do 8739 ibc = 0, nb-1
      a (iap +ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2) = a (iap +
     &   ibr*imstrr +ibc*imstrc+iin1*imstr1+iin2*imstr2)* fwk(ivip+ibc*
     &   ibstrr+iin1*ibstr1+iin2*ibstr2)
 8739 continue
 8737 continue
 8735 continue
 8733 continue
 8731           continue
              endif
 8705       continue
 8703     continue
          fparm(23) = fparm(23) + (1.*nb*nb*nsten*ns)
          issclr = 0
          endif
          if (idbufp .ne. (iparm(6))) then
          do 8741 iaxis = 1, ndim
            iminc(iaxis) = 0 +(-1)*ja(iaxis+ndim*(1 -1))
             do 8743 isten = 2, nsten
      iminc(iaxis) = min(iminc(iaxis), 0 +(-1)*ja(iaxis+ndim*(isten-1)))
 8743 continue
            imaxc(iaxis) = ja(iaxis+ndim*nsten)-1+(-1)*ja(iaxis+ndim*(1 
     &         -1))
             do 8745 isten = 2, nsten
      imaxc(iaxis) = max(imaxc(iaxis), ja(iaxis+ndim*nsten)-1 +(-1)*ja(
     &   iaxis+ndim*(isten-1)))
 8745 continue
 8741     continue
          ncpprd = 1
          do 8747 iaxis = 1, ndim
            ncpmin(iaxis) = ifloor(iminc(iaxis),ja(iaxis+ndim*nsten))
            ncpmax(iaxis) = ifloor(imaxc(iaxis),ja(iaxis+ndim*nsten))
            ncp (iaxis) = max(0,ncpmax(iaxis)-ncpmin(iaxis)+1)
            ncpprd = ncpprd * ncp(iaxis)
 8747     continue
            do 8749 iprc = (ncpprd-1), 0, -1
          call ii2mi (iprcmi,iprc,ndim,ncp)
           do 8751 iaxis = 1, ndim
      iprcmi(iaxis) = iprcmi(iaxis) + ncpmin(iaxis)
 8751 continue
          call ii2mi (imi2,igrid(ipme,ndim,ja(1+ndim*(nsten+1))),ndim,
     &       ja(1+ndim*(nsten+1)))
           do 8753 iaxis = 1, ndim
      imi3(iaxis) = imodf(imi2(iaxis)+iprcmi(iaxis), ja(iaxis+ndim*(
     &   nsten+1)))
 8753 continue
          ipsend = iproc(imi2i(imi3,ndim,ja(1+ndim*(nsten+1))),ndim,ja(
     &       1+ndim*(nsten+1)))
           do 8755 iaxis = 1, ndim
      imi3(iaxis) = imodf(imi2(iaxis)-iprcmi(iaxis), ja(iaxis+ndim*(
     &   nsten+1)))
 8755 continue
          iprecv = iproc(imi2i(imi3,ndim,ja(1+ndim*(nsten+1))),ndim,ja(
     &       1+ndim*(nsten+1)))
          if (-1 .eq. +1) then
             do 8757 iaxis = 1, ndim
      imi2(iaxis) = iprcmi(iaxis) - ncpmin(iaxis)
 8757 continue
      else
             do 8759 iaxis = 1, ndim
      imi2(iaxis) = ncpmax(iaxis) - iprcmi(iaxis)
 8759 continue
      endif
          ibuf = imi2i (imi2,ndim,ncp)
      call dffre (iwk(idbufp+ibuf),iwk(idbufl+ibuf), iparm , fparm , 
     &   iwk , fwk , ier )
           if (ier .lt. 0) go to 900
 8749       continue
          endif
      call xifre (idbufl,ncpprd, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call xifre (idbufp,ncpprd, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
*
           do 8761 ibr = 1, nb
       do 8763 is = 1, ns
      b(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = b(ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)) * fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8763 continue
 8761 continue
          fparm(23) = fparm(23) + (1.*nb*ns)
           do 8765 ibr = 1, nb
       do 8767 is = 1, ns
      u(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = u(ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten)) / fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,nsten))
 8767 continue
 8765 continue
          fparm(23) = fparm(23) + (4.*nb*ns)
          if (iparm(19) .eq. 1) then
             do 8769 ibr = 1, nb
       do 8771 is = 1, ns
      uexact(ivaxgr(ibr,is,ia(5),nb,ns,nsten)) = uexact(ivaxgr(ibr,is,
     &   ia(5),nb,ns,nsten)) / fwk(idiag1-1+ivaxgr(ibr,is,ia(5),nb,ns,
     &   nsten))
 8771 continue
 8769 continue
            fparm(23) = fparm(23) + (4.*nb*ns)
          endif
          go to 900
        endif
*
*-----------------------------------------------------------------------
*
      endif
*
*-----------------------------------------------------------------------
*-------------------------------term case-------------------------------
*-----------------------------------------------------------------------
*
  900 continue
*
      if (iparm(11).eq.(iparm(6))) then
        goto 910
      endif
*
*-----------------------------------------------------------------------
*
      if (ijob.eq.-1 .or. ier.lt.0) then
*
*--------------------------no scaling-----------------------------------
*
        if (iparm(41) .eq. 0) then
          go to 910
        endif
*
*--------------------------left scaling---------------------------------
*
        if (iparm(41).eq.2 .or. iparm(41).eq.3) then
      call dffre (idiag1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call xifre (itab,7, iparm , fparm , iwk , fwk , ier )
          go to 910
        endif
*
*----------------------split diag scaling-------------------------------
*
        if (iparm(41) .eq. 1) then
      call dffre (idiag1,iparm(3)*(1), iparm , fparm , iwk , fwk , ier )
      call xifre (itab,7, iparm , fparm , iwk , fwk , ier )
          go to 910
        endif
*-----------------------------------------------------------------------
                ier = -5
                call xersho ( ier, 'dscgr' , iparm , 910 )
      endif
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
*-----------------------------------------------------------------------
      if (ijob.ne.1 .and. ijob.ne.3 .and. ijob.ne.4 .and. ijob.ne.-1) 
     &   then
                ier = -4
                call xersho ( ier, 'dscgr' , iparm , 'Invalid ijob value
     &' )
      endif
*-----------------------------------------------------------------------
*-------------------------final termination-----------------------------
*-----------------------------------------------------------------------
  910 continue
      if (itab .ne. (iparm(6))) then
        iwk(itab+0) = idiag1
        iwk(itab+1) = idiag2
        iwk(itab+2) = isscll
        iwk(itab+3) = issclr
        iwk(itab+4) = idbufp
        iwk(itab+5) = idbufl
        iwk(itab+6) = ncpprd
      endif
      iparm(11) = itab
      return
      end
*-----------------------------------------------------------------------
