************************************************************************
**  ^ROUTINE: WRIGRX - Preconditioning routine for Richardson method
**            preconditioner, regular grid format. Essentially sets the
**            output vector vo to the input vector vi.
**            (^)
      subroutine drigrx ( ijob , ia , ja , a , vi , vo , iwk , fwk , 
     &   iparm , fparm , ier )
**
**  ^DESCRIPTION: Preconditioning routine for Richardson method
**      preconditioner, regular grid format. Essentially sets the
**      output vector vo to the input vector vi.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:03 1996 $
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines: see External declerations below
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    MVFFAL            - preconditioner applyer arg list
*#                    !---Integer Scalars:
*#                        ijob   - requested task (1=setup, -1=terminate)
*#                        ier    - error return value.
*#                    !---Integer Arrays:
*#                        ia     - used to store indexing information for
*#                                 non-zero elements of matrix stored in a.
*#                        iparm  - used to pass integer parameters to and
*#                                 from the package.
*#                        iwk    - integer workspace
*#                    !---Float Arrays:
*#                        a      - array used to store non-zero elements
*#                                 of the matrix A.
*#                        fparm  - used to pass floating point
*#                                 parameters to and from the package.
*#                        fwk    - floating work array space
*#                        vi     - input vector
*#                        vo     - output vector
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       double precision a(*)
       double precision vi(*)
       double precision vo(*)
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
*
      external dwset
*
******^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:03 1996 $
*     $Id: rigrx.fm4,v 1.10 1994/09/06 17:34:57 joubert Exp $
*     $Revision: 1.10 $
************************************************************************
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (ijob.eq.1) then
        iparm(11) = (iparm(6))
        if (iparm(2) .ge. 4) then
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),*) '     Richardson''s Method (null) Precondit
     &ioner.'
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'()')
        endif
        if (ipme .eq. 0) then
          write (iparm(1),'(1x, 60(''*''))')
        endif
        endif
        go to 900
      endif
*
      if (ijob.eq.-1) then
        go to 900
      endif
*
      if (ijob .eq. 5) then
        call dwset ( vo , vi , iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else if (ijob .eq. 6) then
        call dwset ( vo , vi , iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else if (ijob .eq. 7) then
        call dwset ( vo , vi , iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else if (ijob .eq. 8) then
        call dwset ( vo , vi , iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      else
                ier = -4
                call xersho ( ier, 'drigrx' , iparm , ' ' )
                go to 900
      endif
*
  900 continue
*
      return
      end
