************************************************************************
**  ^ROUTINE: WPREC - Routine to precondition and then call itmeth. (^)
**
      subroutine dprec ( wckff, wscff, wscff2, wmvff, wppff, ijob , 
     &   accel , ia , ja , a , u , uexact , b , iwk , fwk , iparm , 
     &   fparm , ier )
**
**
**  ^DESCRIPTION:
**   This routine calls the preconditioner generator routine for the
**   "pp" preconditioner, "ff" matrix format, and passes the result
**   down to the specified accelerator to solve the system.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:04 1996 $
**
**  ^REQUIREMENTS:
*#   Common Blocks: none
*#   Subroutines: See External declerations below
**
**  ^SIDE_EFFECTS:
**
**  ^ALGORITHM:
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
**
**************************************************************************
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
      external wckff
      external wscff
      external wscff2
      external wmvff
      external wppff
*#    PRECAL            - preconditioner routine arg list
*#                    !---Subroutine Names as Arguments:
*#                        accel  - accelerator routine
*#                    !---Integer Scalars:
*#                        ier    - error return value.
*#                        iwffre - next free location in fwk.
*#                        iwifre - next free location in iwk.
*#                    !---Integer Arrays:
*#                        ia     - used to store indexing information for
*#                                 non-zero elements of matrix stored in a.
*#                        iparm  - used to pass integer parameters to and
*#                                 from the package.
*#                        iwk    - integer workspace
*#                    !---Float Arrays:
*#                        a      - array used to store non-zero elements
*#                                 of the matrix A.
*#                        b      - right hand side of the linear system.
*#                        fparm  - used to pass floating point
*#                                 parameters to and from the package.
*#                        fwk    - floating work array space
*#                        u      - solution vector. On input it contains
*#                                 the initial guess.
*#                        ubar   - exact answer (if known)
*#                        (^./src/m4defs/defs_arglists.m4)
**
      integer ijob
      integer ier
      external accel
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       double precision a(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
*
      external ximini
      external ximal
      external xifre
      external dfmini
      external dfmal
      external dffre
      integer itab
*
*
******^^****************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:04 1996 $
*     $Id: prec.fm4,v 1.20 1994/10/26 19:22:27 joubert Exp $
*     $Revision: 1.20 $
************************************************************************
*
*     Here is how it works.  A short table of pointers etc. is allocated,
*     and iparm(iptr) gets the pointer to this table, to remember the table
*     across calls.  This list of pointers and other data has everything
*     needed across calls, like pointer to the matvec and precon setups,
*     etc., and also things needed at a lower level, like pointers
*     for the matvec and precon.
*
*     This code could initialize as many as 6 things: the scaling, matvec
*     and precon initializations for the original matrix, and those for
*     a different matrix possibly different from the one passed in at the
*     init call.
*
*
      itab = (iparm(6))
*
      if (ijob.eq.0 .or. ijob.eq.1 .or. ijob.eq.2) then
      call ximal (itab,21, iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        iparm(11) = itab
        iwk(itab+(0)*3 + (1 )) = 0
        iwk(itab+(0)*3 + (2 )) = 0
        iwk(itab+(1)*3 + (1 )) = 0
        iwk(itab+(1)*3 + (2 )) = 0
        iwk(itab+(2)*3 + (1 )) = 0
        iwk(itab+(2)*3 + (2 )) = 0
        iwk(itab+(3)*3 + (1 )) = 0
        iwk(itab+(3)*3 + (2 )) = 0
        iwk(itab+(4)*3 + (1 )) = 0
        iwk(itab+(4)*3 + (2 )) = 0
        iwk(itab+(5)*3 + (1 )) = 0
        iwk(itab+(5)*3 + (2 )) = 0
      else
        itab = iparm(11)
        if (itab.eq.(iparm(6)) .and. ijob.eq.-1) go to 910
        if (itab .eq. (iparm(6))) then
                ier = -4
                call xersho ( ier, 'dprec' , iparm , 'Argument ijob inco
     &mpatible with null iparm(iptr)' )
                go to 900
        endif
      endif
*
      if (ijob.eq.0 .or. ijob.eq.1 .or. ijob.eq.2) then
        iwk(itab + 20) = ijob
      endif
      if (ijob.eq.4 .and. iwk(itab + 20) .ne.2) then
                ier = -4
                call xersho ( ier, 'dprec' , iparm , 'Argument ijob inco
     &mpatible with value at init' )
                go to 900
      endif
*
      if (ijob.eq.0 .or. ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.4 .or. 
     &   ijob.eq.5) then
        call wckff ( u , uexact , b , ia , ja , a , iwk , iwk , fwk , 
     &     iparm , fparm , WMVFF , WPPFF , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      endif
*
*-----------------------begin initializations---------------------------
*
      if ((ijob.eq.0 .or.ijob.eq.1 .or.ijob.eq.2 ) .and. iparm(41).ne.0)
     &    then
        call wscff ( 1 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
        iwk(itab+(0)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(0)*3 + (1)) = 1
      endif
*
      if ((ijob.eq.0 .or.ijob.eq.1 .or.ijob.eq.2 .or.ijob.eq.3 ) .and. 
     &   iparm(41).ne.0) then
        iparm(11) = iwk(itab+(0)*3 + (0))
        call wscff2 ( 3 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        iwk(itab+(0)*3 + (2)) = 1
      endif
*
      if ( ijob.eq.0 .or.ijob.eq.1 .or.ijob.eq.2) then
        call wmvff ( 1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(1)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(1)*3 + (1)) = 1
      endif
*
      if ((ijob.eq.0 .or.ijob.eq.1 ) .and. iparm(13).ne.0) then
        call wppff ( 1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(2)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(2)*3 + (1)) = 1
      endif
      if ((ijob.eq.2 ) .and. iparm(13).ne.0) then
        call wppff ( 2 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(2)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(2)*3 + (1)) = 1
      endif
*
      if ((ijob.eq.4 .or.ijob.eq.5 ) .and. iparm(41).ne.0) then
        call wscff ( 1 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
        iwk(itab+(3)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(3)*3 + (1)) = 1
      endif
*
      if ((ijob.eq.4 .or.ijob.eq.5 ) .and. iparm(41).ne.0) then
        iparm(11) = iwk(itab+(3)*3 + (0))
        call wscff2 ( 3 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
           if (ier .lt. 0) go to 900
        iwk(itab+(3)*3 + (2)) = 1
      endif
*
      if ( ijob.eq.4 .or.ijob.eq.5) then
        call wmvff ( 1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(4)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(4)*3 + (1)) = 1
      endif
*
      if ((ijob.eq.5 ) .and. iparm(13).ne.0) then
        call wppff ( 1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(5)*3 + (0)) = iparm(11)
           if (ier .lt. 0) go to 900
        iwk(itab+(5)*3 + (1)) = 1
      endif
*
*--------------------------call itmeth routine--------------------------
      if (ijob.eq.0 .or. ijob.eq.3) then
        iwk(itab + 18) = iwk(itab+(1)*3 + (0))
        iwk(itab + 19) = iwk(itab+(2)*3 + (0))
      endif
      if (ijob.eq.4 .or. ijob.eq.5) then
        iwk(itab + 18) = iwk(itab+(4)*3 + (0))
        iwk(itab + 19) = iwk(itab+(5)*3 + (0))
      endif
*
      if (ijob.eq.0 .or. ijob.eq.3 .or. ijob.eq.4 .or. ijob.eq.5) then
        iparm(11) = itab
        call accel ( 0 , WMVFF , ia , ja , a , WPPFF , iwk , iwk , fwk ,
     &      u , uexact , b , iwk , fwk , iparm , fparm , ier )
        fparm(23) = fparm(23) + fparm(13)
           if (ier .lt. 0) go to 900
      endif
*
*------------------------------termination------------------------------
*
  900 continue
*
      if (itab .eq. (iparm(6))) go to 910
*
      if ((ijob.eq.5 .or. ier.lt.0) .and. iparm(13).ne.0 .and. iwk(itab+
     &   (5)*3 + (1)) .eq. 1) then
        iparm(11) = iwk(itab+(5)*3 + (0))
        call wppff ( -1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(5)*3 + (2)) = 0
      endif
*
      if ((ijob.eq.4 .or.ijob.eq.5 .or. ier.lt.0) .and. iwk(itab+(4)*3 +
     &    (1)) .eq. 1) then
        iparm(11) = iwk(itab+(4)*3 + (0))
        call wmvff ( -1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(4)*3 + (1)) = 0
      endif
*
      if ((ijob.eq.4 .or.ijob.eq.5 .or. ier.lt.0) .and. iparm(41).ne.0 
     &   .and. iwk(itab+(3)*3 + (2)) .eq. 1) then
        iparm(11) = iwk(itab+(3)*3 + (0))
        call wscff2 ( 4 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
        iwk(itab+(3)*3 + (2)) = 0
      endif
*
      if ((ijob.eq.4 .or.ijob.eq.5 .or. ier.lt.0) .and. iwk(itab+(3)*3 +
     &    (1)) .eq. 1) then
        iparm(11) = iwk(itab+(3)*3 + (0))
        call wscff2 ( -1 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
        iwk(itab+(3)*3 + (1)) = 0
      endif
*
      if ((ijob.eq.0 .or.ijob.eq.-1 .or. ier.lt.0) .and. iparm(13).ne.0 
     &   .and. iwk(itab+(2)*3 + (1)) .eq. 1) then
        iparm(11) = iwk(itab+(2)*3 + (0))
        call wppff ( -1 , ia , ja , a , u , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(2)*3 + (1)) = 0
      endif
*
      if ((ijob.eq.0 .or.ijob.eq.-1 .or. ier.lt.0) .and. iwk(itab+(1)*3 
     &   + (1)) .eq. 1) then
        iparm(11) = iwk(itab+(1)*3 + (0))
        call wmvff ( -1 , ia , ja , a , b , b , iwk , fwk , iparm , 
     &     fparm , ier )
        iwk(itab+(1)*3 + (1)) = 0
      endif
*
      if ((ijob.eq.0 .or.ijob.eq.1 .or.ijob.eq.2 .or.ijob.eq.3 .or. 
     &   ier.lt.0) .and. iparm(41).ne.0 .and. iwk(itab+(0)*3 + (2)) 
     &   .eq. 1) then
        iparm(11) = iwk(itab+(0)*3 + (0))
        call wscff2 ( (4) , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
        iwk(itab+(0)*3 + (2)) = 0
      endif
*
      if ((ijob.eq.0 .or.ijob.eq.-1 .or. ier.lt.0) .and. iparm(41).ne.0 
     &   .and. iwk(itab+(0)*3 + (1)) .eq. 1) then
        iparm(11) = iwk(itab+(0)*3 + (0))
        call wscff2 ( -1 , ia , ja , a , u , uexact , b , iwk , fwk , 
     &     iparm , fparm , ier )
        iwk(itab+(0)*3 + (1)) = 0
      endif
*
      if ( ijob.eq.0 .or.ijob.eq.-1) then
        iparm(11) = (iparm(6))
      call xifre (itab,21, iparm , fparm , iwk , fwk , ier )
      else
        iparm(11) = itab
      endif
*
  910 continue
      return
      end
