************************************************************************
**  ^ROUTINE: WMETH  - Workhorse routine to implement a particular
**                     itmeth level algorithm, direct communication
**                     interface. (^)
**
      subroutine dmeth ( wmethr , ijob , suba , ia , ja , a , subq , iq 
     &   , jq , q , u , uexact , b , iwk , fwk , iparm , fparm , ier )
**
**  ^DESCRIPTION:
**    Wrapper routine to provide direct communication interface to
**    a given iterative method's reverse communication routine.
**
**  ^AUTHOR:   wdj@beta.lanl.gov
**
**  ^MODIFIED: spencer@navier.ae.utexas.edu on Thu May 16 12:01:08 1996 $
**
**  ^ARGUMENTS: see *Subroutine Arguments* below.
**
**  ^REQUIREMENTS:
**    Common Blocks: none
**    Subroutines:   see below.
**
**  ^SIDE_EFFECTS:
**    See the definition of METHDCLS to see which parameters
**    are modified
**
**  ^ALGORITHM:
**    Wrapper to give direct communication interface for a reverse
**    communication iterative acceleration routine.
**    The central part of this routine is a loop which alternately
**    calls the revcom routine and processes its requests for the
**    matrix-vector product, preconditioning, and so forth.
**
**  ^REFERENCES:
**
**  ^DOCUMENTATION:
************************************************************************
*
      implicit none
          Include 'fcube.h'
*         Include 'veclib.h'
*
*#    METHAL           - accelerator arg list.
*#                        (^./src/m4defs/defs_arglists.m4)
      integer ijob
      integer ier
      external suba, subq
       integer iwk(*)
       integer iparm(*)
       double precision fwk(*)
       double precision fparm(*)
       integer ia(*)
       integer ja(*)
       integer iq(*)
       integer jq(*)
       double precision a(*)
       double precision q(*)
       double precision u(*)
       double precision uexact(*)
       double precision b(*)
      external wmethr
*
      integer ipme
      integer iphost
      integer log2np
      integer nproc
      integer iom
      character*72 errstr
        integer itimer
        double precision tc1, tr1, tc2, tr2
      external ximini
      external ximal
      external xifre
      external dfmini
      external dfmal
      external dffre
      integer iptr
      integer iptrrc
      integer ijobr, ireq
      integer needrc
          integer ivql
          integer iva
          integer ivqr
      double precision flops
*
      external dargck
      external difppr
      external xtimer
*
****^^******************************************************************
*     $Modified: spencer@navier.ae.utexas.edu on Thu May 16 12:01:08 1996 $
*     $Id: meth.fm4,v 1.21 1994/11/22 05:20:38 joubert Exp $
*     $Revision: 1.21 $
************************************************************************
*
      itimer = 0
      ijobr = 1
*
      ipme = mynode ( )
      iphost = myhost ( )
      log2np = nodedim ( )
      nproc = 2**log2np
      if (iparm(27) .eq. 0) iparm(27) = 1
      if (iparm(27) .eq. 1) then
        ier = 0
        if (ijob.eq.1 .or. ijob.eq.2 .or. ijob.eq.0) then
      call ximini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
      call dfmini ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        endif
        call dargck ( iparm , fparm , iwk , fwk , ier )
           if (ier .lt. 0) go to 900
        call xtimer (tc1,tr1,iparm(22),1)
      endif
*
      if (ijob.lt.0 .or. ijob.gt.0) then
                ier = -4
                call xersho ( ier, 'dmeth' , iparm , 'Argument ijob' )
                go to 900
      endif
*
      call xtimer (tc1,tr1,iparm(22),0)
      itimer = 1
*
      if (iparm(27) .eq. 1) then
        call difppr ( 1 , iparm, fparm, ier )
           if (ier .lt. 0) go to 900
      endif
*
      needrc = iparm(15)
      iparm(15) = 0
      iptrrc = (iparm(6))
*
*-----------------------------revcom loop-------------------------------
*
 8511 continue
        flops = fparm(3)
        iptr = iparm(11)
        iparm(11) = iptrrc
        call wmethr ( ijobr , ireq , u , uexact , b , iva , ivql , ivqr 
     &     , iwk , fwk , iparm , fparm , ier )
        iptrrc = iparm(11)
        iparm(11) = iptr
        fparm(13) = fparm(13) + (fparm(3)-flops)
        if (ier .lt. 0) then
          ireq = -1
          go to 900
        endif
*
        if (ijobr .eq. 1) then
          ijobr = 3
        endif
*
        if (ireq .eq. 3) then
      if (iparm(27) .eq. 2) then
        call dsatop ( suba , 18, 3 , ia , ja , a , fwk(ivqr) , fwk(iva) 
     &     , iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
      else
        call suba ( 3 , ia , ja , a , fwk(ivqr) , fwk(iva) )
      endif
        endif
*
        if (ireq .eq. 4) then
      if (iparm(27) .eq. 2) then
        call dsatop ( suba , 18, 4 , ia , ja , a , fwk(iva) , fwk(ivqr) 
     &     , iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
      else
        call suba ( 4 , ia , ja , a , fwk(iva) , fwk(ivqr) )
      endif
        endif
*
        if (ireq .eq. 5) then
      if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) then
          call dwset (fwk(ivql),fwk(iva), iparm , fparm , iwk , fwk , 
     &       ier )
      else
      if (iparm(27) .eq. 2) then
        call dsatop ( subq , 19, 5 , ia , ja , a , fwk(iva) , fwk(ivql) 
     &     , iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
      else
        call subq ( 5 , iq , jq , q , fwk(iva) , fwk(ivql) )
      endif
      endif
        endif
*
        if (ireq .eq. 6) then
      if (.not. ((iparm(13).eq.1).or.(iparm(13).eq.3))) then
          call dwset (fwk(iva),fwk(ivql), iparm , fparm , iwk , fwk , 
     &       ier )
      else
      if (iparm(27) .eq. 2) then
        call dsatop ( subq , 19, 6 , ia , ja , a , fwk(ivql) , fwk(iva) 
     &     , iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
      else
        call subq ( 6 , iq , jq , q , fwk(ivql) , fwk(iva) )
      endif
      endif
        endif
*
        if (ireq .eq. 7) then
      if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call dwset (fwk(ivqr),fwk(ivql), iparm , fparm , iwk , fwk , 
     &       ier )
      else
      if (iparm(27) .eq. 2) then
        call dsatop ( subq , 19, 7 , ia , ja , a , fwk(ivql) , fwk(ivqr)
     &      , iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
      else
        call subq ( 7 , iq , jq , q , fwk(ivql) , fwk(ivqr) )
      endif
      endif
        endif
*
        if (ireq .eq. 8) then
      if (.not. ((iparm(13).eq.2).or.(iparm(13).eq.3))) then
          call dwset (fwk(ivql),fwk(ivqr), iparm , fparm , iwk , fwk , 
     &       ier )
      else
      if (iparm(27) .eq. 2) then
        call dsatop ( subq , 19, 8 , ia , ja , a , fwk(ivqr) , fwk(ivql)
     &      , iwk , fwk , iparm , fparm , ier )
           if (ier .lt. 0) go to 900
      else
        call subq ( 8 , iq , jq , q , fwk(ivqr) , fwk(ivql) )
      endif
      endif
        endif
*
        if (ireq .eq. -1) then
          ijobr = 1
          go to 900
        endif
*
 1600   continue
      go to 8511
*
*-------------------------------terminate-------------------------------
*
  900 continue
*
      if (ijobr .ne. 1) then
        flops = fparm(3)
        ijobr = -1
        iptr = iparm(11)
        iparm(11) = iptrrc
        call wmethr ( ijobr , ireq , u , uexact , b , iva , ivql , ivqr 
     &     , iwk , fwk , iparm , fparm , ier )
        iptrrc = iparm(11)
        iparm(11) = iptr
        fparm(13) = fparm(13) + (fparm(3)-flops)
      endif
      iparm(15) = needrc
*
      if (itimer .eq. 1) then
        call xtimer (tc2,tr2,iparm(22),0)
        fparm(11) = fparm(11) + (tc2-tc1)
        fparm(12) = fparm(12) + (tr2-tr1)
      endif
*
      if (iparm(27) .eq. 1) then
        call difppr ( -1 , iparm, fparm, ier )
      endif
*
      if (iparm(27) .eq. 1) iparm(27) = 0
*
      return
      end
